/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;
import com.nukkitx.protocol.bedrock.packet.ContainerClosePacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.MerchantContainer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.java.inventory.JavaMerchantOffersTranslator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ContainerClosePacket.class)
public class BedrockContainerCloseTranslator
extends PacketTranslator<ContainerClosePacket> {
    @Override
    public void translate(GeyserSession session, ContainerClosePacket packet) {
        Inventory openInventory;
        byte windowId = packet.getId();
        session.sendUpstreamPacket(packet);
        session.setClosingInventory(false);
        if (windowId == -1 && session.getOpenInventory() instanceof MerchantContainer) {
            windowId = (byte)session.getOpenInventory().getId();
        }
        if ((openInventory = session.getOpenInventory()) != null) {
            if (windowId == openInventory.getId()) {
                ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(windowId);
                session.sendDownstreamPacket(closeWindowPacket);
                InventoryUtils.closeInventory(session, windowId, false);
            } else if (openInventory.isPending()) {
                MerchantContainer merchantContainer;
                InventoryUtils.displayInventory(session, openInventory);
                openInventory.setPending(false);
                Inventory inventory = openInventory;
                if (inventory instanceof MerchantContainer && (merchantContainer = (MerchantContainer)inventory).getPendingOffersPacket() != null) {
                    JavaMerchantOffersTranslator.openMerchant(session, merchantContainer.getPendingOffersPacket(), merchantContainer);
                }
            }
        }
    }
}

