/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.data.game.level.block.CommandBlockMode;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundSetCommandBlockPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundSetCommandMinecartPacket;
import com.nukkitx.protocol.bedrock.packet.CommandBlockUpdatePacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=CommandBlockUpdatePacket.class)
public class BedrockCommandBlockUpdateTranslator
extends PacketTranslator<CommandBlockUpdatePacket> {
    @Override
    public void translate(GeyserSession session, CommandBlockUpdatePacket packet) {
        String command = packet.getCommand();
        boolean outputTracked = packet.isOutputTracked();
        if (packet.isBlock()) {
            CommandBlockMode mode = switch (packet.getMode()) {
                case com.nukkitx.protocol.bedrock.data.CommandBlockMode.CHAIN -> CommandBlockMode.SEQUENCE;
                case com.nukkitx.protocol.bedrock.data.CommandBlockMode.REPEATING -> CommandBlockMode.AUTO;
                default -> CommandBlockMode.REDSTONE;
            };
            boolean isConditional = packet.isConditional();
            boolean automatic = !packet.isRedstoneMode();
            ServerboundSetCommandBlockPacket commandBlockPacket = new ServerboundSetCommandBlockPacket(packet.getBlockPosition(), command, mode, outputTracked, isConditional, automatic);
            session.sendDownstreamPacket(commandBlockPacket);
        } else {
            ServerboundSetCommandMinecartPacket commandMinecartPacket = new ServerboundSetCommandMinecartPacket(session.getEntityCache().getEntityByGeyserId(packet.getMinecartRuntimeEntityId()).getEntityId(), command, outputTracked);
            session.sendDownstreamPacket(commandMinecartPacket);
        }
    }
}

