/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Collection;
import org.geysermc.geyser.entity.type.living.animal.TropicalFishEntity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.geysermc.relocate.kyori.adventure.text.TranslatableComponent;
import org.geysermc.relocate.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.relocate.kyori.adventure.text.format.Style;
import org.geysermc.relocate.kyori.adventure.text.format.TextColor;
import org.geysermc.relocate.kyori.adventure.text.format.TextDecoration;

@ItemRemapper
public class TropicalFishBucketTranslator
extends NbtItemStackTranslator {
    private static final Style LORE_STYLE = Style.style((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC);

    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        itemTag.put(new ByteTag("AppendCustomName", 1));
        itemTag.put(new StringTag("CustomName", MinecraftLocale.getLocaleString("entity.minecraft.tropical_fish", session.getLocale())));
        Object bucketVariantTag = itemTag.get("BucketVariantTag");
        if (bucketVariantTag instanceof IntTag) {
            CompoundTag displayTag = (CompoundTag)itemTag.get("display");
            if (displayTag == null) {
                displayTag = new CompoundTag("display");
                itemTag.put(displayTag);
            }
            ArrayList<Tag> lore = new ArrayList<Tag>();
            int varNumber = ((IntTag)bucketVariantTag).getValue();
            int predefinedVariantId = TropicalFishEntity.getPredefinedId(varNumber);
            if (predefinedVariantId != -1) {
                TranslatableComponent tooltip = Component.translatable("entity.minecraft.tropical_fish.predefined." + predefinedVariantId, LORE_STYLE);
                lore.add(0, new StringTag("", MessageTranslator.convertMessage(tooltip, session.getLocale())));
            } else {
                TranslatableComponent typeTooltip = Component.translatable("entity.minecraft.tropical_fish.type." + TropicalFishEntity.getVariantName(varNumber), LORE_STYLE);
                lore.add(0, new StringTag("", MessageTranslator.convertMessage(typeTooltip, session.getLocale())));
                byte baseColor = TropicalFishEntity.getBaseColor(varNumber);
                byte patternColor = TropicalFishEntity.getPatternColor(varNumber);
                Component colorTooltip = Component.translatable("color.minecraft." + TropicalFishEntity.getColorName(baseColor), LORE_STYLE);
                if (baseColor != patternColor) {
                    colorTooltip = colorTooltip.append(Component.text(", ", LORE_STYLE)).append(Component.translatable("color.minecraft." + TropicalFishEntity.getColorName(patternColor), LORE_STYLE));
                }
                lore.add(1, new StringTag("", MessageTranslator.convertMessage(colorTooltip, session.getLocale())));
            }
            ListTag loreTag = (ListTag)displayTag.get("Lore");
            if (loreTag != null) {
                lore.addAll((Collection<Tag>)loreTag.getValue());
            }
            displayTag.put(new ListTag("Lore", lore));
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return mapping.getJavaIdentifier().equals("minecraft:tropical_fish_bucket");
    }
}

