/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;

@ItemRemapper
public class PlayerHeadTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        if (!(itemTag.contains("display") && ((CompoundTag)itemTag.get("display")).contains("Name") || !itemTag.contains("SkullOwner"))) {
            StringTag skullName;
            StringTag name;
            Object skullOwner = itemTag.get("SkullOwner");
            if (skullOwner instanceof StringTag) {
                name = (StringTag)skullOwner;
            } else if (skullOwner instanceof CompoundTag && (skullName = (StringTag)((CompoundTag)skullOwner).get("Name")) != null) {
                name = skullName;
            } else {
                session.getGeyser().getLogger().debug("Not sure how to handle skull head item display. " + itemTag);
                return;
            }
            String displayName = "\u00a7r\u00a7e" + MinecraftLocale.getLocaleString("block.minecraft.player_head.named", session.getLocale()).replace("%s", name.getValue());
            if (!itemTag.contains("display")) {
                itemTag.put(new CompoundTag("display"));
            }
            ((CompoundTag)itemTag.get("display")).put(new StringTag("Name", displayName));
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return mapping.getJavaIdentifier().equals("minecraft:player_head");
    }
}

