/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.Iterator;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.nbt.FireworkBaseTranslator;
import org.geysermc.geyser.util.MathUtils;

@ItemRemapper
public class FireworkRocketTranslator
extends FireworkBaseTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        ListTag explosions;
        CompoundTag fireworks = (CompoundTag)itemTag.get("Fireworks");
        if (fireworks == null) {
            return;
        }
        if (fireworks.get("Flight") != null) {
            fireworks.put(new ByteTag("Flight", MathUtils.getNbtByte(((Tag)fireworks.get("Flight")).getValue())));
        }
        if ((explosions = (ListTag)fireworks.get("Explosions")) == null) {
            return;
        }
        Iterator iterator = explosions.getValue().iterator();
        while (iterator.hasNext()) {
            Tag effect = (Tag)iterator.next();
            CompoundTag effectData = (CompoundTag)effect;
            CompoundTag newEffectData = this.translateExplosionToBedrock(effectData, "");
            explosions.remove(effectData);
            explosions.add(newEffectData);
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        ListTag explosions;
        CompoundTag fireworks = (CompoundTag)itemTag.get("Fireworks");
        if (fireworks == null) {
            return;
        }
        if (fireworks.contains("Flight")) {
            fireworks.put(new ByteTag("Flight", MathUtils.getNbtByte(((Tag)fireworks.get("Flight")).getValue())));
        }
        if ((explosions = (ListTag)fireworks.get("Explosions")) == null) {
            return;
        }
        Iterator iterator = explosions.getValue().iterator();
        while (iterator.hasNext()) {
            Tag effect = (Tag)iterator.next();
            CompoundTag effectData = (CompoundTag)effect;
            CompoundTag newEffectData = this.translateExplosionToJava(effectData, "");
            explosions.remove(effect);
            explosions.add(newEffectData);
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return "minecraft:firework_rocket".equals(mapping.getJavaIdentifier());
    }
}

