/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;

@ItemRemapper
public class EnchantmentTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        CompoundTag bedrockTag;
        Tag tag;
        ListTag listTag;
        ArrayList<Tag> newTags = new ArrayList<Tag>();
        Object enchantmentTag = itemTag.get("Enchantments");
        Object object = enchantmentTag;
        if (object instanceof ListTag) {
            listTag = (ListTag)object;
            object = listTag.getValue().iterator();
            while (object.hasNext()) {
                tag = (Tag)object.next();
                if (!(tag instanceof CompoundTag)) continue;
                bedrockTag = this.remapEnchantment((CompoundTag)tag);
                newTags.add(bedrockTag);
            }
            itemTag.remove("Enchantments");
        }
        if ((object = (enchantmentTag = itemTag.get("StoredEnchantments"))) instanceof ListTag) {
            listTag = (ListTag)object;
            object = listTag.getValue().iterator();
            while (object.hasNext()) {
                tag = (Tag)object.next();
                if (!(tag instanceof CompoundTag) || (bedrockTag = this.remapEnchantment((CompoundTag)tag)) == null) continue;
                bedrockTag.put(new ShortTag("GeyserStoredEnchantment", 0));
                newTags.add(bedrockTag);
            }
            itemTag.remove("StoredEnchantments");
        }
        if (!newTags.isEmpty()) {
            itemTag.put(new ListTag("ench", newTags));
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        if (!itemTag.contains("ench")) {
            return;
        }
        ListTag enchantmentTag = (ListTag)itemTag.get("ench");
        ArrayList<Tag> enchantments = new ArrayList<Tag>();
        ArrayList<Tag> storedEnchantments = new ArrayList<Tag>();
        Iterator iterator = enchantmentTag.getValue().iterator();
        while (iterator.hasNext()) {
            CompoundTag tagValue;
            ShortTag bedrockId;
            Tag value = (Tag)iterator.next();
            Tag tag = value;
            if (!(tag instanceof CompoundTag) || (bedrockId = (ShortTag)(tagValue = (CompoundTag)tag).get("id")) == null) continue;
            ShortTag geyserStoredEnchantmentTag = (ShortTag)tagValue.get("GeyserStoredEnchantment");
            Enchantment enchantment = Enchantment.getByBedrockId(bedrockId.getValue().shortValue());
            if (enchantment != null) {
                CompoundTag javaTag = new CompoundTag("");
                Object javaValue = javaTag.getValue();
                javaValue.put("id", new StringTag("id", enchantment.getJavaIdentifier()));
                ShortTag levelTag = (ShortTag)tagValue.get("lvl");
                javaValue.put("lvl", new IntTag("lvl", levelTag != null ? (int)levelTag.getValue().shortValue() : 1));
                javaTag.setValue((Map<String, Tag>)javaValue);
                if (geyserStoredEnchantmentTag != null) {
                    tagValue.remove("GeyserStoredEnchantment");
                    storedEnchantments.add(javaTag);
                    continue;
                }
                enchantments.add(javaTag);
                continue;
            }
            GeyserImpl.getInstance().getLogger().debug("Unknown bedrock enchantment: " + bedrockId);
        }
        if (!enchantments.isEmpty()) {
            itemTag.put(new ListTag("Enchantments", enchantments));
        }
        if (!storedEnchantments.isEmpty()) {
            itemTag.put(new ListTag("StoredEnchantments", storedEnchantments));
        }
        itemTag.remove("ench");
    }

    private CompoundTag remapEnchantment(CompoundTag tag) {
        short s2;
        Object object;
        Object javaEnchId = tag.get("id");
        if (!(javaEnchId instanceof StringTag)) {
            return null;
        }
        Enchantment enchantment = Enchantment.getByJavaIdentifier(((StringTag)javaEnchId).getValue());
        if (enchantment == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown Java enchantment while NBT item translating: " + ((Tag)javaEnchId).getValue());
            return null;
        }
        Object javaEnchLvl = tag.get("lvl");
        CompoundTag bedrockTag = new CompoundTag("");
        bedrockTag.put(new ShortTag("id", (short)enchantment.ordinal()));
        if (javaEnchLvl != null && (object = ((Tag)javaEnchLvl).getValue()) instanceof Number) {
            Number lvl = (Number)object;
            s2 = lvl.shortValue();
        } else {
            s2 = 0;
        }
        bedrockTag.put(new ShortTag("lvl", s2));
        return bedrockTag;
    }
}

