/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.List;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;

@ItemRemapper(priority=1)
public class EnchantedBookTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        if (!itemTag.contains("StoredEnchantments")) {
            return;
        }
        Object enchTag = itemTag.get("StoredEnchantments");
        if (enchTag instanceof ListTag) {
            enchTag = new ListTag("Enchantments", (List<Tag>)((ListTag)enchTag).getValue());
            itemTag.remove("StoredEnchantments");
            itemTag.put(enchTag);
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        if (!itemTag.contains("Enchantments")) {
            return;
        }
        Object enchTag = itemTag.get("Enchantments");
        if (enchTag instanceof ListTag) {
            enchTag = new ListTag("StoredEnchantments", (List<Tag>)((ListTag)enchTag).getValue());
            itemTag.remove("Enchantments");
            itemTag.put(enchTag);
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return "minecraft:enchanted_book".equals(mapping.getJavaIdentifier());
    }
}

