/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;

@ItemRemapper
public class BookPagesTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        if (!itemTag.contains("pages")) {
            return;
        }
        ArrayList<Tag> pages = new ArrayList<Tag>();
        ListTag pagesTag = (ListTag)itemTag.get("pages");
        Iterator iterator = pagesTag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            Tag tag2 = tag;
            if (!(tag2 instanceof StringTag)) continue;
            StringTag textTag = (StringTag)tag2;
            CompoundTag pageTag = new CompoundTag("");
            pageTag.put(new StringTag("photoname", ""));
            pageTag.put(new StringTag("text", MessageTranslator.convertMessageLenient(textTag.getValue())));
            pages.add(pageTag);
        }
        itemTag.remove("pages");
        itemTag.put(new ListTag("pages", pages));
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        if (!itemTag.contains("pages")) {
            return;
        }
        ArrayList<Tag> pages = new ArrayList<Tag>();
        ListTag pagesTag = (ListTag)itemTag.get("pages");
        Iterator iterator = pagesTag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            Tag tag2 = tag;
            if (!(tag2 instanceof CompoundTag)) continue;
            CompoundTag pageTag = (CompoundTag)tag2;
            StringTag textTag = (StringTag)pageTag.get("text");
            pages.add(new StringTag("", textTag.getValue()));
        }
        itemTag.remove("pages");
        itemTag.put(new ListTag("pages", pages));
    }
}

