/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.TippedArrowPotion;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

@ItemRemapper
public class TippedArrowTranslator
extends ItemTranslator {
    private static final int TIPPED_ARROW_JAVA_ID = Registries.ITEMS.forVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getMapping("minecraft:tipped_arrow").getJavaId();

    @Override
    protected ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        if (!mapping.getJavaIdentifier().equals("minecraft:tipped_arrow") || itemStack.getNbt() == null) {
            return super.translateToBedrock(itemStack, mapping, mappings);
        }
        Object potionTag = itemStack.getNbt().get("Potion");
        if (potionTag instanceof StringTag) {
            TippedArrowPotion tippedArrowPotion = TippedArrowPotion.getByJavaIdentifier(((StringTag)potionTag).getValue());
            if (tippedArrowPotion != null) {
                return ItemData.builder().id(mapping.getBedrockId()).damage(tippedArrowPotion.getBedrockId()).count(itemStack.getAmount()).tag(this.translateNbtToBedrock(itemStack.getNbt()));
            }
            GeyserImpl.getInstance().getLogger().debug("Unknown Java potion (tipped arrow): " + ((Tag)potionTag).getValue());
        }
        return super.translateToBedrock(itemStack, mapping, mappings);
    }

    @Override
    public ItemStack translateToJava(ItemData itemData, ItemMapping mapping, ItemMappings mappings) {
        TippedArrowPotion tippedArrowPotion = TippedArrowPotion.getByBedrockId(itemData.getDamage());
        ItemStack itemStack = super.translateToJava(itemData, mapping, mappings);
        if (tippedArrowPotion != null) {
            itemStack = new ItemStack(TIPPED_ARROW_JAVA_ID, itemStack.getAmount(), itemStack.getNbt());
            StringTag potionTag = new StringTag("Potion", tippedArrowPotion.getJavaIdentifier());
            itemStack.getNbt().put(potionTag);
        }
        return itemStack;
    }

    @Override
    public List<ItemMapping> getAppliedItems() {
        return Arrays.stream(Registries.ITEMS.forVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getItems()).filter(entry -> entry.getJavaIdentifier().contains("arrow") && !entry.getJavaIdentifier().contains("spectral")).collect(Collectors.toList());
    }
}

