/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

@ItemRemapper
public class PotionTranslator
extends ItemTranslator {
    @Override
    protected ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        if (itemStack.getNbt() == null) {
            return super.translateToBedrock(itemStack, mapping, mappings);
        }
        Object potionTag = itemStack.getNbt().get("Potion");
        if (potionTag instanceof StringTag) {
            Potion potion = Potion.getByJavaIdentifier(((StringTag)potionTag).getValue());
            if (potion != null) {
                return ItemData.builder().id(mapping.getBedrockId()).damage(potion.getBedrockId()).count(itemStack.getAmount()).tag(this.translateNbtToBedrock(itemStack.getNbt()));
            }
            GeyserImpl.getInstance().getLogger().debug("Unknown Java potion: " + ((Tag)potionTag).getValue());
        }
        return super.translateToBedrock(itemStack, mapping, mappings);
    }

    @Override
    public ItemStack translateToJava(ItemData itemData, ItemMapping mapping, ItemMappings mappings) {
        Potion potion = Potion.getByBedrockId(itemData.getDamage());
        ItemStack itemStack = super.translateToJava(itemData, mapping, mappings);
        if (potion != null) {
            StringTag potionTag = new StringTag("Potion", potion.getJavaIdentifier());
            itemStack.getNbt().put(potionTag);
        }
        return itemStack;
    }

    @Override
    public List<ItemMapping> getAppliedItems() {
        return Arrays.stream(Registries.ITEMS.forVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getItems()).filter(entry -> entry.getJavaIdentifier().endsWith("potion")).collect(Collectors.toList());
    }
}

