/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import java.util.Collections;
import java.util.List;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

@ItemRemapper
public class GoatHornTranslator
extends ItemTranslator {
    private static final List<String> INSTRUMENTS = List.of("ponder_goat_horn", "sing_goat_horn", "seek_goat_horn", "feel_goat_horn", "admire_goat_horn", "call_goat_horn", "yearn_goat_horn", "dream_goat_horn");

    @Override
    protected ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        Object t2;
        ItemData.Builder builder = super.translateToBedrock(itemStack, mapping, mappings);
        if (itemStack.getNbt() != null && (t2 = itemStack.getNbt().get("instrument")) instanceof StringTag) {
            int damage;
            StringTag instrumentTag = (StringTag)t2;
            String instrument = instrumentTag.getValue();
            if (instrument.startsWith("minecraft:")) {
                instrument = instrument.substring("minecraft:".length());
            }
            if ((damage = INSTRUMENTS.indexOf(instrument)) == -1) {
                damage = 0;
                GeyserImpl.getInstance().getLogger().debug("Unknown goat horn instrument: " + instrumentTag.getValue());
            }
            builder.damage(damage);
        }
        return builder;
    }

    @Override
    public ItemStack translateToJava(ItemData itemData, ItemMapping mapping, ItemMappings mappings) {
        ItemStack itemStack = super.translateToJava(itemData, mapping, mappings);
        int damage = itemData.getDamage();
        if (damage < 0 || damage >= INSTRUMENTS.size()) {
            GeyserImpl.getInstance().getLogger().debug("Unknown goat horn instrument for damage: " + damage);
            damage = 0;
        }
        String instrument = INSTRUMENTS.get(damage);
        StringTag instrumentTag = new StringTag("instrument", "minecraft:" + instrument);
        itemStack.getNbt().put(instrumentTag);
        return itemStack;
    }

    @Override
    public List<ItemMapping> getAppliedItems() {
        return Collections.singletonList(Registries.ITEMS.forVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getMapping("minecraft:goat_horn"));
    }
}

