/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtType;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerSlotType;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerType;
import com.nukkitx.protocol.bedrock.data.inventory.ItemStackRequest;
import com.nukkitx.protocol.bedrock.data.inventory.StackRequestSlotInfoData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.CraftLoomStackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.CraftResultsDeprecatedStackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionType;
import com.nukkitx.protocol.bedrock.packet.ItemStackResponsePacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.translator.inventory.item.nbt.BannerTranslator;

public class LoomInventoryTranslator
extends AbstractBlockInventoryTranslator {
    private static final Object2IntMap<String> PATTERN_TO_INDEX = new Object2IntOpenHashMap();

    public LoomInventoryTranslator() {
        super(4, "minecraft:loom[facing=north]", ContainerType.LOOM, UIInventoryUpdater.INSTANCE, new String[0]);
    }

    @Override
    protected boolean shouldRejectItemPlace(GeyserSession session, Inventory inventory, ContainerSlotType bedrockSourceContainer, int javaSourceSlot, ContainerSlotType bedrockDestinationContainer, int javaDestinationSlot) {
        GeyserItemStack itemStack;
        if (javaDestinationSlot != 1) {
            return false;
        }
        GeyserItemStack geyserItemStack = itemStack = javaSourceSlot == -1 ? session.getPlayerInventory().getCursor() : inventory.getItem(javaSourceSlot);
        if (itemStack.isEmpty()) {
            return false;
        }
        return !itemStack.getMapping(session).getJavaIdentifier().endsWith("_dye");
    }

    @Override
    protected boolean shouldHandleRequestFirst(StackRequestActionData action, Inventory inventory) {
        return action.getType() == StackRequestActionType.CRAFT_LOOM && inventory.getItem(2).isEmpty();
    }

    @Override
    public ItemStackResponsePacket.Response translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        StackRequestActionData headerData = request.getActions()[0];
        StackRequestActionData data = request.getActions()[1];
        if (!(headerData instanceof CraftLoomStackRequestActionData)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        StackRequestActionData stackRequestActionData = data;
        if (!(stackRequestActionData instanceof CraftResultsDeprecatedStackRequestActionData)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        CraftResultsDeprecatedStackRequestActionData craftData = (CraftResultsDeprecatedStackRequestActionData)stackRequestActionData;
        List<NbtMap> newBlockEntityTag = craftData.getResultItems()[0].getTag().getList("Patterns", NbtType.COMPOUND);
        NbtMap pattern = newBlockEntityTag.get(newBlockEntityTag.size() - 1);
        String bedrockPattern = ((CraftLoomStackRequestActionData)headerData).getPatternId();
        int index = PATTERN_TO_INDEX.getOrDefault((Object)bedrockPattern, -1);
        if (index == -1) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getId(), index);
        session.sendDownstreamPacket(packet);
        GeyserItemStack inputCopy = inventory.getItem(0).copy(1);
        inputCopy.setNetId(session.getNextItemNetId());
        if (inputCopy.getNbt() == null) {
            inputCopy.setNbt(new CompoundTag(""));
        }
        CompoundTag blockEntityTag = (CompoundTag)inputCopy.getNbt().get("BlockEntityTag");
        CompoundTag javaBannerPattern = BannerTranslator.getJavaBannerPattern(pattern);
        if (blockEntityTag != null) {
            ListTag patternsList = (ListTag)blockEntityTag.get("Patterns");
            if (patternsList != null) {
                patternsList.add(javaBannerPattern);
            } else {
                patternsList = new ListTag("Patterns", Collections.singletonList(javaBannerPattern));
                blockEntityTag.put(patternsList);
            }
        } else {
            blockEntityTag = new CompoundTag("BlockEntityTag");
            ListTag patternsList = new ListTag("Patterns", Collections.singletonList(javaBannerPattern));
            blockEntityTag.put(patternsList);
            inputCopy.getNbt().put(blockEntityTag);
        }
        inventory.setItem(3, inputCopy, session);
        return this.translateRequest(session, inventory, request);
    }

    @Override
    public int bedrockSlotToJava(StackRequestSlotInfoData slotInfoData) {
        return switch (slotInfoData.getContainer()) {
            case ContainerSlotType.LOOM_INPUT -> 0;
            case ContainerSlotType.LOOM_DYE -> 1;
            case ContainerSlotType.LOOM_MATERIAL -> 2;
            case ContainerSlotType.LOOM_RESULT, ContainerSlotType.CREATIVE_OUTPUT -> 3;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.LOOM_INPUT, 9);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.LOOM_DYE, 10);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.LOOM_MATERIAL, 11);
            case 3 -> new BedrockContainerSlot(ContainerSlotType.LOOM_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot);
        };
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 9;
            case 1 -> 10;
            case 2 -> 11;
            case 3 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 3) {
            return SlotType.OUTPUT;
        }
        return super.getSlotType(javaSlot);
    }

    static {
        int index = 0;
        PATTERN_TO_INDEX.put((Object)"bl", index++);
        PATTERN_TO_INDEX.put((Object)"br", index++);
        PATTERN_TO_INDEX.put((Object)"tl", index++);
        PATTERN_TO_INDEX.put((Object)"tr", index++);
        PATTERN_TO_INDEX.put((Object)"bs", index++);
        PATTERN_TO_INDEX.put((Object)"ts", index++);
        PATTERN_TO_INDEX.put((Object)"ls", index++);
        PATTERN_TO_INDEX.put((Object)"rs", index++);
        PATTERN_TO_INDEX.put((Object)"cs", index++);
        PATTERN_TO_INDEX.put((Object)"ms", index++);
        PATTERN_TO_INDEX.put((Object)"drs", index++);
        PATTERN_TO_INDEX.put((Object)"dls", index++);
        PATTERN_TO_INDEX.put((Object)"ss", index++);
        PATTERN_TO_INDEX.put((Object)"cr", index++);
        PATTERN_TO_INDEX.put((Object)"sc", index++);
        PATTERN_TO_INDEX.put((Object)"bt", index++);
        PATTERN_TO_INDEX.put((Object)"tt", index++);
        PATTERN_TO_INDEX.put((Object)"bts", index++);
        PATTERN_TO_INDEX.put((Object)"tts", index++);
        PATTERN_TO_INDEX.put((Object)"ld", index++);
        PATTERN_TO_INDEX.put((Object)"rd", index++);
        PATTERN_TO_INDEX.put((Object)"lud", index++);
        PATTERN_TO_INDEX.put((Object)"rud", index++);
        PATTERN_TO_INDEX.put((Object)"mc", index++);
        PATTERN_TO_INDEX.put((Object)"mr", index++);
        PATTERN_TO_INDEX.put((Object)"vh", index++);
        PATTERN_TO_INDEX.put((Object)"hh", index++);
        PATTERN_TO_INDEX.put((Object)"vhr", index++);
        PATTERN_TO_INDEX.put((Object)"hhb", index++);
        PATTERN_TO_INDEX.put((Object)"bo", index++);
        int n = ++index;
        PATTERN_TO_INDEX.put((Object)"gra", n);
        PATTERN_TO_INDEX.put((Object)"gru", ++index);
    }
}

