/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import com.nukkitx.protocol.bedrock.data.inventory.ContainerSlotType;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerType;
import com.nukkitx.protocol.bedrock.packet.ContainerOpenPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Generic3X3Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class Generic3X3InventoryTranslator
extends AbstractBlockInventoryTranslator {
    public Generic3X3InventoryTranslator() {
        super(9, "minecraft:dispenser[facing=north,triggered=false]", ContainerType.DISPENSER, ContainerInventoryUpdater.INSTANCE, "minecraft:dropper");
    }

    @Override
    public Inventory createInventory(String name, int windowId, com.github.steveice10.mc.protocol.data.game.inventory.ContainerType containerType, PlayerInventory playerInventory) {
        return new Generic3X3Container(name, windowId, this.size, containerType, playerInventory);
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)inventory.getId());
        containerOpenPacket.setType(((Generic3X3Container)inventory).isDropper() ? ContainerType.DROPPER : ContainerType.DISPENSER);
        containerOpenPacket.setBlockPosition(inventory.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(inventory.getHolderId());
        session.sendUpstreamPacket(containerOpenPacket);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int javaSlot) {
        if (javaSlot < this.size) {
            return new BedrockContainerSlot(ContainerSlotType.CONTAINER, javaSlot);
        }
        return super.javaSlotToBedrockContainer(javaSlot);
    }
}

