/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="_trapdoor$", usesParams=true, passDefaultBoxes=true)
public class TrapdoorCollision
extends BlockCollision {
    private int facing;

    public TrapdoorCollision(String params, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        if (params.contains("open=true")) {
            if (params.contains("facing=north")) {
                this.facing = 1;
            } else if (params.contains("facing=east")) {
                this.facing = 2;
            } else if (params.contains("facing=south")) {
                this.facing = 3;
            } else if (params.contains("facing=west")) {
                this.facing = 4;
            }
        } else {
            this.facing = params.contains("half=bottom") ? 5 : 6;
        }
    }

    @Override
    public boolean correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        boolean result = super.correctPosition(session, x, y, z, playerCollision);
        if (this.checkIntersection(x, y, z, playerCollision)) {
            switch (this.facing) {
                case 1: {
                    playerCollision.setMiddleZ((double)z + 0.5125);
                    break;
                }
                case 2: {
                    playerCollision.setMiddleX((double)x + 0.5125);
                    break;
                }
                case 3: {
                    playerCollision.setMiddleZ((double)z + 0.4875);
                    break;
                }
                case 4: {
                    playerCollision.setMiddleX((double)x + 0.4875);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    playerCollision.setMiddleY((double)(y + 1) - 0.1875 - playerCollision.getSizeY() / 2.0 - 1.0E-5);
                }
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrapdoorCollision)) {
            return false;
        }
        TrapdoorCollision other = (TrapdoorCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.facing == other.facing;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TrapdoorCollision;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.facing;
        return result;
    }
}

