/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^snow$", passDefaultBoxes=true, usesParams=true)
public class SnowCollision
extends BlockCollision {
    private final int layers;

    public SnowCollision(String params, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        int layerCharIndex = params.indexOf("=") + 1;
        this.layers = Integer.parseInt(params.substring(layerCharIndex, layerCharIndex + 1));
        this.pushUpTolerance = 0.125;
    }

    @Override
    public void beforeCorrectPosition(int x, int y, int z, BoundingBox playerCollision) {
        double boxMaxY;
        double playerMinY;
        if ((this.layers == 4 || this.layers == 8) && (playerMinY = playerCollision.getMiddleY() - playerCollision.getSizeY() / 2.0) > (boxMaxY = this.boundingBoxes[0].getMiddleY() + (double)y + this.boundingBoxes[0].getSizeY() / 2.0) && playerMinY <= boxMaxY + 0.125) {
            playerCollision.translate(0.0, boxMaxY - playerMinY, 0.0);
        }
    }

    @Override
    public boolean correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        if (this.layers == 1) {
            return true;
        }
        playerCollision.setSizeX(playerCollision.getSizeX() - 1.0E-4);
        playerCollision.setSizeY(playerCollision.getSizeY() - 1.0E-4);
        playerCollision.setSizeZ(playerCollision.getSizeZ() - 1.0E-4);
        if (this.checkIntersection(x, y, z, playerCollision)) {
            double playerMinY = playerCollision.getMiddleY() - playerCollision.getSizeY() / 2.0;
            double boxMaxY = this.boundingBoxes[0].getMiddleY() + (double)y + this.boundingBoxes[0].getSizeY() / 2.0;
            if (boxMaxY - playerMinY > 0.5) {
                return false;
            }
        }
        playerCollision.setSizeX(playerCollision.getSizeX() + 1.0E-4);
        playerCollision.setSizeY(playerCollision.getSizeY() + 1.0E-4);
        playerCollision.setSizeZ(playerCollision.getSizeZ() + 1.0E-4);
        return super.correctPosition(session, x, y, z, playerCollision);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowCollision)) {
            return false;
        }
        SnowCollision other = (SnowCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.layers == other.layers;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SnowCollision;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.layers;
        return result;
    }
}

