/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import com.nukkitx.math.vector.Vector3d;
import com.nukkitx.math.vector.Vector3i;
import java.util.Arrays;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;

public class BlockCollision {
    protected final BoundingBox[] boundingBoxes;
    protected double pushUpTolerance = 1.0;
    protected double pushAwayTolerance = 1.1000000000000001E-5;

    protected BlockCollision(BoundingBox[] boxes) {
        this.boundingBoxes = boxes;
    }

    public void beforeCorrectPosition(int x, int y, int z, BoundingBox playerCollision) {
    }

    public boolean correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        double playerMinY = playerCollision.getMiddleY() - playerCollision.getSizeY() / 2.0;
        for (BoundingBox b : this.boundingBoxes) {
            double boxMinY = b.getMiddleY() + (double)y - b.getSizeY() / 2.0;
            double boxMaxY = b.getMiddleY() + (double)y + b.getSizeY() / 2.0;
            if (b.checkIntersection(x, y, z, playerCollision) && playerMinY + this.pushUpTolerance >= boxMinY && boxMaxY - playerMinY <= 0.5625) {
                playerCollision.translate(0.0, boxMaxY - playerMinY, 0.0);
                playerMinY = playerCollision.getMiddleY() - playerCollision.getSizeY() / 2.0;
            }
            playerCollision.setSizeX(playerCollision.getSizeX() + 2.0E-5);
            playerCollision.setSizeZ(playerCollision.getSizeZ() + 2.0E-5);
            if (b.checkIntersection(x, y, z, playerCollision)) {
                double bottomFaceYPos;
                double westFaceXPos;
                double eastFaceXPos;
                double southFaceZPos;
                Vector3d relativePlayerPosition = Vector3d.from(playerCollision.getMiddleX() - (double)x, playerCollision.getMiddleY() - (double)y, playerCollision.getMiddleZ() - (double)z);
                double xULP = Math.ulp((float)Math.max(Math.abs(playerCollision.getMiddleX()) + playerCollision.getSizeX() / 2.0, (double)(Math.abs(x) + 1)));
                double zULP = Math.ulp((float)Math.max(Math.abs(playerCollision.getMiddleZ()) + playerCollision.getSizeZ() / 2.0, (double)(Math.abs(z) + 1)));
                double xPushAwayTolerance = Math.max(this.pushAwayTolerance, xULP);
                double zPushAwayTolerance = Math.max(this.pushAwayTolerance, zULP);
                double northFaceZPos = b.getMiddleZ() - b.getSizeZ() / 2.0;
                double translateDistance = northFaceZPos - relativePlayerPosition.getZ() - playerCollision.getSizeZ() / 2.0;
                if (Math.abs(translateDistance) < zPushAwayTolerance) {
                    playerCollision.translate(0.0, 0.0, translateDistance);
                }
                if (Math.abs(translateDistance = (southFaceZPos = b.getMiddleZ() + b.getSizeZ() / 2.0) - relativePlayerPosition.getZ() + playerCollision.getSizeZ() / 2.0) < zPushAwayTolerance) {
                    playerCollision.translate(0.0, 0.0, translateDistance);
                }
                if (Math.abs(translateDistance = (eastFaceXPos = b.getMiddleX() + b.getSizeX() / 2.0) - relativePlayerPosition.getX() + playerCollision.getSizeX() / 2.0) < xPushAwayTolerance) {
                    playerCollision.translate(translateDistance, 0.0, 0.0);
                }
                if (Math.abs(translateDistance = (westFaceXPos = b.getMiddleX() - b.getSizeX() / 2.0) - relativePlayerPosition.getX() - playerCollision.getSizeX() / 2.0) < xPushAwayTolerance) {
                    playerCollision.translate(translateDistance, 0.0, 0.0);
                }
                if (Math.abs(translateDistance = (bottomFaceYPos = b.getMiddleY() - b.getSizeY() / 2.0) - relativePlayerPosition.getY() - playerCollision.getSizeY() / 2.0) < this.pushAwayTolerance) {
                    playerCollision.translate(0.0, translateDistance, 0.0);
                }
            }
            playerCollision.setSizeX(0.6);
            playerCollision.setSizeZ(0.6);
        }
        return true;
    }

    public boolean checkIntersection(double x, double y, double z, BoundingBox playerCollision) {
        for (BoundingBox b : this.boundingBoxes) {
            if (!b.checkIntersection(x, y, z, playerCollision)) continue;
            return true;
        }
        return false;
    }

    public boolean checkIntersection(Vector3i position, BoundingBox playerCollision) {
        return this.checkIntersection(position.getX(), position.getY(), position.getZ(), playerCollision);
    }

    public double computeCollisionOffset(double x, double y, double z, BoundingBox boundingBox, Axis axis, double offset) {
        for (BoundingBox b : this.boundingBoxes) {
            if (!(Math.abs(offset = b.getMaxOffset(x, y, z, boundingBox, axis, offset)) < 1.0E-5)) continue;
            return 0.0;
        }
        return offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockCollision)) {
            return false;
        }
        BlockCollision other = (BlockCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.pushUpTolerance, other.pushUpTolerance) != 0) {
            return false;
        }
        if (Double.compare(this.pushAwayTolerance, other.pushAwayTolerance) != 0) {
            return false;
        }
        return Arrays.deepEquals(this.getBoundingBoxes(), other.getBoundingBoxes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockCollision;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pushUpTolerance = Double.doubleToLongBits(this.pushUpTolerance);
        result = result * 59 + (int)($pushUpTolerance >>> 32 ^ $pushUpTolerance);
        long $pushAwayTolerance = Double.doubleToLongBits(this.pushAwayTolerance);
        result = result * 59 + (int)($pushAwayTolerance >>> 32 ^ $pushAwayTolerance);
        result = result * 59 + Arrays.deepHashCode(this.getBoundingBoxes());
        return result;
    }

    public BoundingBox[] getBoundingBoxes() {
        return this.boundingBoxes;
    }
}

