/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.ProvidedSkin;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.relocate.jackson.databind.JsonNode;
import org.geysermc.relocate.jackson.databind.ObjectMapper;

public class SkinProvider {
    public static final boolean ALLOW_THIRD_PARTY_CAPES = GeyserImpl.getInstance().getConfig().isAllowThirdPartyCapes();
    static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(ALLOW_THIRD_PARTY_CAPES ? 21 : 14);
    public static final byte[] STEVE_SKIN = new ProvidedSkin("bedrock/skin/skin_steve.png").getSkin();
    public static final Skin EMPTY_SKIN = new Skin(-1L, "steve", STEVE_SKIN);
    public static final byte[] ALEX_SKIN = new ProvidedSkin("bedrock/skin/skin_alex.png").getSkin();
    public static final Skin EMPTY_SKIN_ALEX = new Skin(-1L, "alex", ALEX_SKIN);
    private static final Map<String, Skin> permanentSkins = new HashMap<String, Skin>(){
        {
            this.put("steve", EMPTY_SKIN);
            this.put("alex", EMPTY_SKIN_ALEX);
        }
    };
    private static final Cache<String, Skin> cachedSkins = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final Map<String, CompletableFuture<Skin>> requestedSkins = new ConcurrentHashMap<String, CompletableFuture<Skin>>();
    public static final Cape EMPTY_CAPE = new Cape("", "no-cape", new byte[0], -1L, true);
    private static final Cache<String, Cape> cachedCapes = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final Map<String, CompletableFuture<Cape>> requestedCapes = new ConcurrentHashMap<String, CompletableFuture<Cape>>();
    private static final Map<UUID, SkinGeometry> cachedGeometry = new ConcurrentHashMap<UUID, SkinGeometry>();
    public static final Predicate<UUID> IS_NPC = uuid -> uuid.version() == 2;
    public static final boolean ALLOW_THIRD_PARTY_EARS = GeyserImpl.getInstance().getConfig().isAllowThirdPartyEars();
    public static final String EARS_GEOMETRY;
    public static final String EARS_GEOMETRY_SLIM;
    public static final SkinGeometry SKULL_GEOMETRY;
    public static final SkinGeometry WEARING_CUSTOM_SKULL;
    public static final SkinGeometry WEARING_CUSTOM_SKULL_SLIM;
    public static final ObjectMapper OBJECT_MAPPER;

    public static void registerCacheImageTask(GeyserImpl geyser) {
        if (geyser.getConfig().getCacheImages() > 0) {
            geyser.getScheduledThread().scheduleAtFixedRate(() -> {
                File cacheFolder = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("images").toFile();
                if (!cacheFolder.exists()) {
                    return;
                }
                int count = 0;
                long expireTime = (long)GeyserImpl.getInstance().getConfig().getCacheImages() * 86400000L;
                for (File imageFile : Objects.requireNonNull(cacheFolder.listFiles())) {
                    if (imageFile.lastModified() >= System.currentTimeMillis() - expireTime) continue;
                    imageFile.delete();
                    ++count;
                }
                if (count > 0) {
                    GeyserImpl.getInstance().getLogger().debug(String.format("Removed %d cached image files as they have expired", count));
                }
            }, 10L, 1440L, TimeUnit.MINUTES);
        }
    }

    public static boolean hasCapeCached(String capeUrl) {
        return cachedCapes.getIfPresent((Object)capeUrl) != null;
    }

    public static Skin getCachedSkin(String skinUrl) {
        return permanentSkins.getOrDefault(skinUrl, (Skin)cachedSkins.getIfPresent((Object)skinUrl));
    }

    public static Cape getCachedCape(String capeUrl) {
        Cape cape = capeUrl != null ? (Cape)cachedCapes.getIfPresent((Object)capeUrl) : EMPTY_CAPE;
        return cape != null ? cape : EMPTY_CAPE;
    }

    public static CompletableFuture<SkinData> requestSkinData(PlayerEntity entity) {
        SkinManager.GameProfileData data = SkinManager.GameProfileData.from(entity);
        return SkinProvider.requestSkinAndCape(entity.getUuid(), data.skinUrl(), data.capeUrl()).thenApplyAsync(skinAndCape -> {
            try {
                Skin skin = skinAndCape.getSkin();
                Cape cape = skinAndCape.getCape();
                SkinGeometry geometry = SkinGeometry.getLegacy(data.isAlex());
                if (cape.isFailed()) {
                    cape = SkinProvider.getOrDefault(SkinProvider.requestBedrockCape(entity.getUuid()), EMPTY_CAPE, 3);
                }
                if (cape.isFailed() && ALLOW_THIRD_PARTY_CAPES) {
                    cape = SkinProvider.getOrDefault(SkinProvider.requestUnofficialCape(cape, entity.getUuid(), entity.getUsername(), false), EMPTY_CAPE, CapeProvider.VALUES.length * 3);
                }
                geometry = SkinProvider.getOrDefault(SkinProvider.requestBedrockGeometry(geometry, entity.getUuid()), geometry, 3);
                boolean isDeadmau5 = "deadmau5".equals(entity.getUsername());
                if (geometry.isFailed() && (ALLOW_THIRD_PARTY_EARS || isDeadmau5)) {
                    boolean isEars;
                    if (isDeadmau5) {
                        isEars = true;
                    } else {
                        skin = SkinProvider.getOrDefault(SkinProvider.requestUnofficialEars(skin, entity.getUuid(), entity.getUsername(), false), skin, 3);
                        isEars = skin.isEars();
                    }
                    if (isEars) {
                        geometry = SkinGeometry.getEars(data.isAlex());
                        SkinProvider.storeEarSkin(skin);
                        SkinProvider.storeEarGeometry(entity.getUuid(), data.isAlex());
                    }
                }
                return new SkinData(skin, cape, geometry);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), e);
                return new SkinData(skinAndCape.getSkin(), skinAndCape.getCape(), null);
            }
        });
    }

    public static CompletableFuture<SkinAndCape> requestSkinAndCape(UUID playerId, String skinUrl, String capeUrl) {
        return CompletableFuture.supplyAsync(() -> {
            GeyserSession session;
            long time = System.currentTimeMillis();
            String newSkinUrl = skinUrl;
            if (("steve".equals(skinUrl) || "alex".equals(skinUrl)) && (session = GeyserImpl.getInstance().connectionByUuid(playerId)) != null) {
                newSkinUrl = session.getClientData().getSkinId();
            }
            CapeProvider provider = capeUrl != null ? CapeProvider.MINECRAFT : null;
            SkinAndCape skinAndCape = new SkinAndCape(SkinProvider.getOrDefault(SkinProvider.requestSkin(playerId, newSkinUrl, false), EMPTY_SKIN, 5), SkinProvider.getOrDefault(SkinProvider.requestCape(capeUrl, provider, false), EMPTY_CAPE, 5));
            GeyserImpl.getInstance().getLogger().debug("Took " + (System.currentTimeMillis() - time) + "ms for " + playerId);
            return skinAndCape;
        }, EXECUTOR_SERVICE);
    }

    public static CompletableFuture<Skin> requestSkin(UUID playerId, String textureUrl, boolean newThread) {
        CompletionStage<Skin> future;
        if (textureUrl == null || textureUrl.isEmpty()) {
            return CompletableFuture.completedFuture(EMPTY_SKIN);
        }
        CompletableFuture<Skin> requestedSkin = requestedSkins.get(textureUrl);
        if (requestedSkin != null) {
            return requestedSkin;
        }
        Skin cachedSkin = SkinProvider.getCachedSkin(textureUrl);
        if (cachedSkin != null) {
            return CompletableFuture.completedFuture(cachedSkin);
        }
        if (newThread) {
            future = CompletableFuture.supplyAsync(() -> SkinProvider.supplySkin(playerId, textureUrl), EXECUTOR_SERVICE).whenCompleteAsync((skin, throwable) -> {
                skin.updated = true;
                cachedSkins.put((Object)textureUrl, skin);
                requestedSkins.remove(textureUrl);
            });
            requestedSkins.put(textureUrl, (CompletableFuture<Skin>)future);
        } else {
            Skin skin2 = SkinProvider.supplySkin(playerId, textureUrl);
            future = CompletableFuture.completedFuture(skin2);
            cachedSkins.put((Object)textureUrl, (Object)skin2);
        }
        return future;
    }

    public static CompletableFuture<Cape> requestCape(String capeUrl, CapeProvider provider, boolean newThread) {
        CompletionStage<Cape> future;
        if (capeUrl == null || capeUrl.isEmpty()) {
            return CompletableFuture.completedFuture(EMPTY_CAPE);
        }
        if (requestedCapes.containsKey(capeUrl)) {
            return requestedCapes.get(capeUrl);
        }
        Cape cachedCape = (Cape)cachedCapes.getIfPresent((Object)capeUrl);
        if (cachedCape != null) {
            return CompletableFuture.completedFuture(cachedCape);
        }
        if (newThread) {
            future = CompletableFuture.supplyAsync(() -> SkinProvider.supplyCape(capeUrl, provider), EXECUTOR_SERVICE).whenCompleteAsync((cape, throwable) -> {
                cachedCapes.put((Object)capeUrl, cape);
                requestedCapes.remove(capeUrl);
            });
            requestedCapes.put(capeUrl, (CompletableFuture<Cape>)future);
        } else {
            Cape cape2 = SkinProvider.supplyCape(capeUrl, provider);
            future = CompletableFuture.completedFuture(cape2);
            cachedCapes.put((Object)capeUrl, (Object)cape2);
        }
        return future;
    }

    public static CompletableFuture<Cape> requestUnofficialCape(Cape officialCape, UUID playerId, String username, boolean newThread) {
        if (officialCape.isFailed() && ALLOW_THIRD_PARTY_CAPES) {
            for (CapeProvider provider : CapeProvider.VALUES) {
                Cape cape1;
                if (provider.type != CapeUrlType.USERNAME && IS_NPC.test(playerId) || (cape1 = SkinProvider.getOrDefault(SkinProvider.requestCape(provider.getUrlFor(playerId, username), provider, newThread), EMPTY_CAPE, 4)).isFailed()) continue;
                return CompletableFuture.completedFuture(cape1);
            }
        }
        return CompletableFuture.completedFuture(officialCape);
    }

    public static CompletableFuture<Skin> requestEars(String earsUrl, boolean newThread, Skin skin) {
        CompletionStage<Skin> future;
        if (earsUrl == null || earsUrl.isEmpty()) {
            return CompletableFuture.completedFuture(skin);
        }
        if (newThread) {
            future = CompletableFuture.supplyAsync(() -> SkinProvider.supplyEars(skin, earsUrl), EXECUTOR_SERVICE).whenCompleteAsync((outSkin, throwable) -> {});
        } else {
            Skin ears = SkinProvider.supplyEars(skin, earsUrl);
            future = CompletableFuture.completedFuture(ears);
        }
        return future;
    }

    public static CompletableFuture<Skin> requestUnofficialEars(Skin officialSkin, UUID playerId, String username, boolean newThread) {
        for (EarsProvider provider : EarsProvider.VALUES) {
            Skin skin1;
            if (provider.type != CapeUrlType.USERNAME && IS_NPC.test(playerId) || !(skin1 = SkinProvider.getOrDefault(SkinProvider.requestEars(provider.getUrlFor(playerId, username), newThread, officialSkin), officialSkin, 4)).isEars()) continue;
            return CompletableFuture.completedFuture(skin1);
        }
        return CompletableFuture.completedFuture(officialSkin);
    }

    public static CompletableFuture<Cape> requestBedrockCape(UUID playerID) {
        Cape bedrockCape = (Cape)cachedCapes.getIfPresent((Object)(playerID.toString() + ".Bedrock"));
        if (bedrockCape == null) {
            bedrockCape = EMPTY_CAPE;
        }
        return CompletableFuture.completedFuture(bedrockCape);
    }

    public static CompletableFuture<SkinGeometry> requestBedrockGeometry(SkinGeometry currentGeometry, UUID playerID) {
        SkinGeometry bedrockGeometry = cachedGeometry.getOrDefault(playerID, currentGeometry);
        return CompletableFuture.completedFuture(bedrockGeometry);
    }

    public static void storeBedrockSkin(UUID playerID, String skinID, byte[] skinData) {
        Skin skin = new Skin(playerID, skinID, skinData, System.currentTimeMillis(), true, false);
        cachedSkins.put((Object)skin.getTextureUrl(), (Object)skin);
    }

    public static void storeBedrockCape(UUID playerID, byte[] capeData) {
        Cape cape = new Cape(playerID.toString() + ".Bedrock", playerID.toString(), capeData, System.currentTimeMillis(), false);
        cachedCapes.put((Object)(playerID.toString() + ".Bedrock"), (Object)cape);
    }

    public static void storeBedrockGeometry(UUID playerID, byte[] geometryName, byte[] geometryData) {
        SkinGeometry geometry = new SkinGeometry(new String(geometryName), new String(geometryData), false);
        cachedGeometry.put(playerID, geometry);
    }

    public static void storeEarSkin(Skin skin) {
        cachedSkins.put((Object)skin.getTextureUrl(), (Object)skin);
    }

    public static void storeEarGeometry(UUID playerID, boolean isSlim) {
        cachedGeometry.put(playerID, SkinGeometry.getEars(isSlim));
    }

    private static Skin supplySkin(UUID uuid, String textureUrl) {
        try {
            byte[] skin = SkinProvider.requestImage(textureUrl, null);
            return new Skin(uuid, textureUrl, skin, System.currentTimeMillis(), false, false);
        }
        catch (Exception exception) {
            return new Skin(uuid, "empty", EMPTY_SKIN.getSkinData(), System.currentTimeMillis(), false, false);
        }
    }

    private static Cape supplyCape(String capeUrl, CapeProvider provider) {
        byte[] cape = EMPTY_CAPE.getCapeData();
        try {
            cape = SkinProvider.requestImage(capeUrl, provider);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] urlSection = capeUrl.split("/");
        return new Cape(capeUrl, urlSection[urlSection.length - 1], cape, System.currentTimeMillis(), cape.length == 0);
    }

    private static Skin supplyEars(Skin existingSkin, String earsUrl) {
        try {
            BufferedImage ears = ImageIO.read(new URL(earsUrl));
            if (ears == null) {
                throw new NullPointerException();
            }
            int height = existingSkin.getSkinData().length / 4 / 64;
            BufferedImage skinImage = SkinProvider.imageDataToBufferedImage(existingSkin.getSkinData(), 64, height);
            BufferedImage newSkin = new BufferedImage(skinImage.getWidth(), skinImage.getHeight(), 2);
            Graphics2D g2 = (Graphics2D)newSkin.getGraphics();
            g2.drawImage((Image)skinImage, 0, 0, null);
            g2.drawImage((Image)ears, 24, 0, null);
            byte[] data = SkinProvider.bufferedImageToImageData(newSkin);
            skinImage.flush();
            return new Skin(existingSkin.getSkinOwner(), existingSkin.getTextureUrl(), data, System.currentTimeMillis(), true, true);
        }
        catch (Exception exception) {
            return existingSkin;
        }
    }

    private static byte[] requestImage(String imageUrl, CapeProvider provider) throws Exception {
        BufferedImage image = null;
        File imageFile = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("images").resolve(UUID.nameUUIDFromBytes(imageUrl.getBytes()).toString() + ".png").toFile();
        if (imageFile.exists()) {
            try {
                GeyserImpl.getInstance().getLogger().debug("Reading cached image from file " + imageFile.getPath() + " for " + imageUrl);
                imageFile.setLastModified(System.currentTimeMillis());
                image = ImageIO.read(imageFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            image = SkinProvider.downloadImage(imageUrl, provider);
            GeyserImpl.getInstance().getLogger().debug("Downloaded " + imageUrl);
            if (GeyserImpl.getInstance().getConfig().getCacheImages() > 0) {
                imageFile.getParentFile().mkdirs();
                try {
                    ImageIO.write((RenderedImage)image, "png", imageFile);
                    GeyserImpl.getInstance().getLogger().debug("Writing cached skin to file " + imageFile.getPath() + " for " + imageUrl);
                }
                catch (IOException e) {
                    GeyserImpl.getInstance().getLogger().error("Failed to write cached skin to file " + imageFile.getPath() + " for " + imageUrl);
                }
            }
        }
        if (provider != null) {
            if (image.getWidth() > 64 || image.getHeight() > 32) {
                newImage = new BufferedImage(128, 64, 2);
                Graphics2D g2 = newImage.createGraphics();
                g2.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                g2.dispose();
                image.flush();
                image = SkinProvider.scale(newImage, 64, 32);
            } else if (image.getWidth() < 64 || image.getHeight() < 32) {
                newImage = new BufferedImage(64, 32, 2);
                Graphics2D g3 = newImage.createGraphics();
                g3.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                g3.dispose();
                image.flush();
                image = newImage;
            }
        } else if (image.getWidth() > 128) {
            image = SkinProvider.scale(image, 128, image.getHeight() >= 256 ? image.getHeight() / (image.getWidth() / 128) : 128);
        }
        byte[] data = SkinProvider.bufferedImageToImageData(image);
        image.flush();
        return data;
    }

    public static CompletableFuture<String> requestTexturesFromUsername(CompoundTag skullOwner) {
        return CompletableFuture.supplyAsync(() -> {
            boolean retrieveUuidFromInternet;
            Object uuidTag = skullOwner.get("Id");
            String uuidToString = "";
            boolean bl = retrieveUuidFromInternet = !(uuidTag instanceof IntArrayTag);
            if (!retrieveUuidFromInternet) {
                int[] uuidAsArray = ((IntArrayTag)uuidTag).getValue();
                UUID uuid = new UUID((long)uuidAsArray[0] << 32 | (long)uuidAsArray[1] & 0xFFFFFFFFL, (long)uuidAsArray[2] << 32 | (long)uuidAsArray[3] & 0xFFFFFFFFL);
                retrieveUuidFromInternet = uuid.version() != 4;
                uuidToString = uuid.toString().replace("-", "");
            }
            try {
                JsonNode properties;
                JsonNode node;
                if (retrieveUuidFromInternet) {
                    node = WebUtils.getJson("https://api.mojang.com/users/profiles/minecraft/" + ((Tag)skullOwner.get("Name")).getValue());
                    JsonNode id = node.get("id");
                    if (id == null) {
                        GeyserImpl.getInstance().getLogger().debug("No UUID found in Mojang response for " + ((Tag)skullOwner.get("Name")).getValue());
                        return null;
                    }
                    uuidToString = id.asText();
                }
                if ((properties = (node = WebUtils.getJson("https://sessionserver.mojang.com/session/minecraft/profile/" + uuidToString)).get("properties")) == null) {
                    GeyserImpl.getInstance().getLogger().debug("No properties found in Mojang response for " + uuidToString);
                    return null;
                }
                return node.get("properties").get(0).get("value").asText();
            }
            catch (Exception e) {
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }, EXECUTOR_SERVICE);
    }

    private static BufferedImage downloadImage(String imageUrl, CapeProvider provider) throws IOException {
        if (provider == CapeProvider.FIVEZIG) {
            return SkinProvider.readFiveZigCape(imageUrl);
        }
        HttpURLConnection con = (HttpURLConnection)new URL(imageUrl).openConnection();
        con.setRequestProperty("User-Agent", "Geyser-" + GeyserImpl.getInstance().getPlatformType().toString() + "/2.0.6-SNAPSHOT (git-eab92da98884308b6e4b4a5deb1de97b2fbd3c6e-eab92da)");
        con.setConnectTimeout(10000);
        con.setReadTimeout(10000);
        BufferedImage image = ImageIO.read(con.getInputStream());
        if (image == null) {
            throw new NullPointerException();
        }
        return image;
    }

    private static BufferedImage readFiveZigCape(String url) throws IOException {
        JsonNode element = OBJECT_MAPPER.readTree(WebUtils.getBody(url));
        if (element != null && element.isObject()) {
            JsonNode capeElement = element.get("d");
            if (capeElement == null || capeElement.isNull()) {
                return null;
            }
            return ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(capeElement.textValue())));
        }
        return null;
    }

    public static BufferedImage scale(BufferedImage bufferedImage, int newWidth, int newHeight) {
        BufferedImage resized = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2 = resized.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
        g2.dispose();
        bufferedImage.flush();
        return resized;
    }

    private static int getRGBA(int index, byte[] data) {
        return (data[index] & 0xFF) << 16 | (data[index + 1] & 0xFF) << 8 | data[index + 2] & 0xFF | (data[index + 3] & 0xFF) << 24;
    }

    public static BufferedImage imageDataToBufferedImage(byte[] imageData, int imageWidth, int imageHeight) {
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        int index = 0;
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                image.setRGB(x, y, SkinProvider.getRGBA(index, imageData));
                index += 4;
            }
        }
        return image;
    }

    public static byte[] bufferedImageToImageData(BufferedImage image) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(image.getWidth() * 4 + image.getHeight() * 4);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgba = image.getRGB(x, y);
                outputStream.write(rgba >> 16 & 0xFF);
                outputStream.write(rgba >> 8 & 0xFF);
                outputStream.write(rgba & 0xFF);
                outputStream.write(rgba >> 24 & 0xFF);
            }
        }
        return outputStream.toByteArray();
    }

    public static <T> T getOrDefault(CompletableFuture<T> future, T defaultValue, int timeoutInSeconds) {
        try {
            return future.get(timeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
        EARS_GEOMETRY = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.ears.json"), StandardCharsets.UTF_8);
        EARS_GEOMETRY_SLIM = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.earsSlim.json"), StandardCharsets.UTF_8);
        String skullData = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.customskull.json"), StandardCharsets.UTF_8);
        SKULL_GEOMETRY = new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.customskull\"}}", skullData, false);
        String wearingCustomSkull = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.wearingCustomSkull.json"), StandardCharsets.UTF_8);
        WEARING_CUSTOM_SKULL = new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.wearingCustomSkull\"}}", wearingCustomSkull, false);
        String wearingCustomSkullSlim = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.wearingCustomSkullSlim.json"), StandardCharsets.UTF_8);
        WEARING_CUSTOM_SKULL_SLIM = new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.wearingCustomSkullSlim\"}}", wearingCustomSkullSlim, false);
    }

    public static class Skin {
        private UUID skinOwner;
        private final String textureUrl;
        private final byte[] skinData;
        private final long requestedOn;
        private boolean updated;
        private boolean ears;

        private Skin(long requestedOn, String textureUrl, byte[] skinData) {
            this.requestedOn = requestedOn;
            this.textureUrl = textureUrl;
            this.skinData = skinData;
        }

        public Skin(UUID skinOwner, String textureUrl, byte[] skinData, long requestedOn, boolean updated, boolean ears) {
            this.skinOwner = skinOwner;
            this.textureUrl = textureUrl;
            this.skinData = skinData;
            this.requestedOn = requestedOn;
            this.updated = updated;
            this.ears = ears;
        }

        public UUID getSkinOwner() {
            return this.skinOwner;
        }

        public String getTextureUrl() {
            return this.textureUrl;
        }

        public byte[] getSkinData() {
            return this.skinData;
        }

        public long getRequestedOn() {
            return this.requestedOn;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public boolean isEars() {
            return this.ears;
        }
    }

    public static class Cape {
        private final String textureUrl;
        private final String capeId;
        private final byte[] capeData;
        private final long requestedOn;
        private final boolean failed;

        public Cape(String textureUrl, String capeId, byte[] capeData, long requestedOn, boolean failed) {
            this.textureUrl = textureUrl;
            this.capeId = capeId;
            this.capeData = capeData;
            this.requestedOn = requestedOn;
            this.failed = failed;
        }

        public String getTextureUrl() {
            return this.textureUrl;
        }

        public String getCapeId() {
            return this.capeId;
        }

        public byte[] getCapeData() {
            return this.capeData;
        }

        public long getRequestedOn() {
            return this.requestedOn;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }

    public static enum CapeProvider {
        MINECRAFT,
        OPTIFINE("https://optifine.net/capes/%s.png", CapeUrlType.USERNAME),
        LABYMOD("https://dl.labymod.net/capes/%s", CapeUrlType.UUID_DASHED),
        FIVEZIG("https://textures.5zigreborn.eu/profile/%s", CapeUrlType.UUID_DASHED),
        MINECRAFTCAPES("https://minecraftcapes.net/profile/%s/cape", CapeUrlType.UUID);

        public static final CapeProvider[] VALUES;
        private String url;
        private CapeUrlType type;

        public String getUrlFor(String type) {
            return String.format(this.url, type);
        }

        public String getUrlFor(UUID uuid, String username) {
            return this.getUrlFor(CapeProvider.toRequestedType(this.type, uuid, username));
        }

        public static String toRequestedType(CapeUrlType type, UUID uuid, String username) {
            return switch (type) {
                case CapeUrlType.UUID -> uuid.toString().replace("-", "");
                case CapeUrlType.UUID_DASHED -> uuid.toString();
                default -> username;
            };
        }

        private CapeProvider(String url, CapeUrlType type) {
            this.url = url;
            this.type = type;
        }

        private CapeProvider() {
        }

        public String getUrl() {
            return this.url;
        }

        public CapeUrlType getType() {
            return this.type;
        }

        static {
            VALUES = Arrays.copyOfRange(CapeProvider.values(), 1, 5);
        }
    }

    public static enum CapeUrlType {
        USERNAME,
        UUID,
        UUID_DASHED;

    }

    public static enum EarsProvider {
        MINECRAFTCAPES("https://minecraftcapes.net/profile/%s/ears", CapeUrlType.UUID);

        public static final EarsProvider[] VALUES;
        private String url;
        private CapeUrlType type;

        public String getUrlFor(String type) {
            return String.format(this.url, type);
        }

        public String getUrlFor(UUID uuid, String username) {
            return this.getUrlFor(EarsProvider.toRequestedType(this.type, uuid, username));
        }

        public static String toRequestedType(CapeUrlType type, UUID uuid, String username) {
            return switch (type) {
                case CapeUrlType.UUID -> uuid.toString().replace("-", "");
                case CapeUrlType.UUID_DASHED -> uuid.toString();
                default -> username;
            };
        }

        private EarsProvider(String url, CapeUrlType type) {
            this.url = url;
            this.type = type;
        }

        private EarsProvider() {
        }

        public String getUrl() {
            return this.url;
        }

        public CapeUrlType getType() {
            return this.type;
        }

        static {
            VALUES = EarsProvider.values();
        }
    }

    public static class SkinGeometry {
        private final String geometryName;
        private final String geometryData;
        private final boolean failed;

        public static SkinGeometry getLegacy(boolean isSlim) {
            return new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.custom" + (isSlim ? "Slim" : "") + "\"}}", "", true);
        }

        public static SkinGeometry getEars(boolean isSlim) {
            return new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.ears" + (isSlim ? "Slim" : "") + "\"}}", isSlim ? EARS_GEOMETRY_SLIM : EARS_GEOMETRY, false);
        }

        public SkinGeometry(String geometryName, String geometryData, boolean failed) {
            this.geometryName = geometryName;
            this.geometryData = geometryData;
            this.failed = failed;
        }

        public String getGeometryName() {
            return this.geometryName;
        }

        public String getGeometryData() {
            return this.geometryData;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }

    public static class SkinAndCape {
        private final Skin skin;
        private final Cape cape;

        public SkinAndCape(Skin skin, Cape cape) {
            this.skin = skin;
            this.cape = cape;
        }

        public Skin getSkin() {
            return this.skin;
        }

        public Cape getCape() {
            return this.cape;
        }
    }

    public record SkinData(Skin skin, Cape cape, SkinGeometry geometry) {
    }
}

