/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.nukkitx.protocol.bedrock.data.skin.ImageData;
import com.nukkitx.protocol.bedrock.data.skin.SerializedSkin;
import com.nukkitx.protocol.bedrock.packet.PlayerListPacket;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class SkinManager {
    public static PlayerListPacket.Entry buildCachedEntry(GeyserSession session, PlayerEntity playerEntity) {
        GameProfileData data = GameProfileData.from(playerEntity);
        SkinProvider.Cape cape = SkinProvider.getCachedCape(data.capeUrl());
        SkinProvider.SkinGeometry geometry = SkinProvider.SkinGeometry.getLegacy(data.isAlex());
        SkinProvider.Skin skin = SkinProvider.getCachedSkin(data.skinUrl());
        if (skin == null) {
            skin = SkinProvider.EMPTY_SKIN;
        }
        return SkinManager.buildEntryManually(session, playerEntity.getUuid(), playerEntity.getUsername(), playerEntity.getGeyserId(), skin.getTextureUrl(), skin.getSkinData(), cape.getCapeId(), cape.getCapeData(), geometry);
    }

    public static PlayerListPacket.Entry buildEntryManually(GeyserSession session, UUID uuid, String username, long geyserId, String skinId, byte[] skinData, String capeId, byte[] capeData, SkinProvider.SkinGeometry geometry) {
        SerializedSkin serializedSkin = SerializedSkin.of(skinId, "", geometry.getGeometryName(), ImageData.of(skinData), Collections.emptyList(), ImageData.of(capeData), geometry.getGeometryData(), "", true, false, !capeId.equals(SkinProvider.EMPTY_CAPE.getCapeId()), capeId, skinId);
        String xuid = "";
        GeyserSession playerSession = GeyserImpl.getInstance().connectionByUuid(uuid);
        if (playerSession != null) {
            xuid = playerSession.getAuthData().xuid();
        }
        PlayerListPacket.Entry entry = session.getPlayerEntity().getUuid().equals(uuid) ? new PlayerListPacket.Entry(session.getAuthData().uuid()) : new PlayerListPacket.Entry(uuid);
        entry.setName(username);
        entry.setEntityId(geyserId);
        entry.setSkin(serializedSkin);
        entry.setXuid(xuid);
        entry.setPlatformChatId("");
        entry.setTeacher(false);
        entry.setTrustedSkin(true);
        return entry;
    }

    public static void requestAndHandleSkinAndCape(PlayerEntity entity, GeyserSession session, Consumer<SkinProvider.SkinAndCape> skinAndCapeConsumer) {
        SkinProvider.requestSkinData(entity).whenCompleteAsync((skinData, throwable) -> {
            if (skinData == null) {
                if (skinAndCapeConsumer != null) {
                    skinAndCapeConsumer.accept(null);
                }
                return;
            }
            if (skinData.geometry() != null) {
                SkinProvider.Skin skin = skinData.skin();
                SkinProvider.Cape cape = skinData.cape();
                SkinProvider.SkinGeometry geometry = skinData.geometry();
                PlayerListPacket.Entry updatedEntry = SkinManager.buildEntryManually(session, entity.getUuid(), entity.getUsername(), entity.getGeyserId(), skin.getTextureUrl(), skin.getSkinData(), cape.getCapeId(), cape.getCapeData(), geometry);
                PlayerListPacket playerAddPacket = new PlayerListPacket();
                playerAddPacket.setAction(PlayerListPacket.Action.ADD);
                playerAddPacket.getEntries().add(updatedEntry);
                session.sendUpstreamPacket(playerAddPacket);
                if (!entity.isPlayerList()) {
                    PlayerListPacket playerRemovePacket = new PlayerListPacket();
                    playerRemovePacket.setAction(PlayerListPacket.Action.REMOVE);
                    playerRemovePacket.getEntries().add(updatedEntry);
                    session.sendUpstreamPacket(playerRemovePacket);
                }
            }
            if (skinAndCapeConsumer != null) {
                skinAndCapeConsumer.accept(new SkinProvider.SkinAndCape(skinData.skin(), skinData.cape()));
            }
        });
    }

    public static void handleBedrockSkin(PlayerEntity playerEntity, BedrockClientData clientData) {
        GeyserImpl geyser = GeyserImpl.getInstance();
        if (geyser.getConfig().isDebugMode()) {
            geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.register", playerEntity.getUsername(), playerEntity.getUuid()));
        }
        try {
            byte[] skinBytes = Base64.getDecoder().decode(clientData.getSkinData().getBytes(StandardCharsets.UTF_8));
            byte[] capeBytes = clientData.getCapeData();
            byte[] geometryNameBytes = Base64.getDecoder().decode(clientData.getGeometryName().getBytes(StandardCharsets.UTF_8));
            byte[] geometryBytes = Base64.getDecoder().decode(clientData.getGeometryData().getBytes(StandardCharsets.UTF_8));
            if (skinBytes.length <= 65536 && !clientData.isPersonaSkin()) {
                SkinProvider.storeBedrockSkin(playerEntity.getUuid(), clientData.getSkinId(), skinBytes);
                SkinProvider.storeBedrockGeometry(playerEntity.getUuid(), geometryNameBytes, geometryBytes);
            } else if (geyser.getConfig().isDebugMode()) {
                geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.fail", playerEntity.getUsername()));
                geyser.getLogger().debug("The size of '" + playerEntity.getUsername() + "' skin is: " + clientData.getSkinImageWidth() + "x" + clientData.getSkinImageHeight());
            }
            if (!clientData.getCapeId().equals("")) {
                SkinProvider.storeBedrockCape(playerEntity.getUuid(), capeBytes);
            }
        }
        catch (Exception e) {
            throw new AssertionError("Failed to cache skin for bedrock user (" + playerEntity.getUsername() + "): ", e);
        }
    }

    public record GameProfileData(String skinUrl, String capeUrl, boolean isAlex) {
        @Nullable
        public static GameProfileData from(CompoundTag tag) {
            ListTag texturesTag;
            Object t2 = tag.get("Properties");
            if (!(t2 instanceof CompoundTag)) {
                return null;
            }
            CompoundTag propertiesTag = (CompoundTag)t2;
            Object t3 = propertiesTag.get("textures");
            if (!(t3 instanceof ListTag) || (texturesTag = (ListTag)t3).size() == 0) {
                return null;
            }
            Object t4 = texturesTag.get(0);
            if (!(t4 instanceof CompoundTag)) {
                return null;
            }
            CompoundTag texturesData = (CompoundTag)t4;
            Object t5 = texturesData.get("Value");
            if (!(t5 instanceof StringTag)) {
                return null;
            }
            StringTag skinDataValue = (StringTag)t5;
            try {
                return GameProfileData.loadFromJson(skinDataValue.getValue());
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for tag " + tag);
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        public static GameProfileData from(PlayerEntity entity) {
            try {
                String texturesProperty = entity.getTexturesProperty();
                if (texturesProperty == null) {
                    return GameProfileData.loadBedrockOrOfflineSkin(entity);
                }
                GameProfileData data = GameProfileData.loadFromJson(texturesProperty);
                if (data != null) {
                    return data;
                }
                return GameProfileData.loadBedrockOrOfflineSkin(entity);
            }
            catch (IOException exception) {
                GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for " + entity.getUsername());
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    exception.printStackTrace();
                }
                return GameProfileData.loadBedrockOrOfflineSkin(entity);
            }
        }

        private static GameProfileData loadFromJson(String encodedJson) throws IOException {
            JsonNode skinObject = GeyserImpl.JSON_MAPPER.readTree(new String(Base64.getDecoder().decode(encodedJson), StandardCharsets.UTF_8));
            JsonNode textures = skinObject.get("textures");
            if (textures != null) {
                JsonNode skinTexture = textures.get("SKIN");
                String skinUrl = skinTexture.get("url").asText().replace("http://", "https://");
                boolean isAlex = skinTexture.has("metadata");
                String capeUrl = null;
                JsonNode capeTexture = textures.get("CAPE");
                if (capeTexture != null) {
                    capeUrl = capeTexture.get("url").asText().replace("http://", "https://");
                }
                return new GameProfileData(skinUrl, capeUrl, isAlex);
            }
            return null;
        }

        private static GameProfileData loadBedrockOrOfflineSkin(PlayerEntity entity) {
            GeyserSession session;
            UUID uuid = entity.getUuid();
            boolean isAlex = Math.abs(uuid.hashCode() % 2) == 1;
            String skinUrl = isAlex ? SkinProvider.EMPTY_SKIN_ALEX.getTextureUrl() : SkinProvider.EMPTY_SKIN.getTextureUrl();
            String capeUrl = SkinProvider.EMPTY_CAPE.getTextureUrl();
            if (("steve".equals(skinUrl) || "alex".equals(skinUrl)) && GeyserImpl.getInstance().getConfig().getRemote().getAuthType() != AuthType.ONLINE && (session = GeyserImpl.getInstance().connectionByUuid(uuid)) != null) {
                skinUrl = session.getClientData().getSkinId();
                capeUrl = session.getClientData().getCapeId();
            }
            return new GameProfileData(skinUrl, capeUrl, isAlex);
        }
    }
}

