/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.geysermc.geyser.GeyserImpl;

public class ProvidedSkin {
    private byte[] skin;

    public ProvidedSkin(String internalUrl) {
        try {
            BufferedImage image;
            try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource(internalUrl);){
                image = ImageIO.read(stream);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(image.getWidth() * 4 + image.getHeight() * 4);
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int rgba = image.getRGB(x, y);
                    outputStream.write(rgba >> 16 & 0xFF);
                    outputStream.write(rgba >> 8 & 0xFF);
                    outputStream.write(rgba & 0xFF);
                    outputStream.write(rgba >> 24 & 0xFF);
                }
            }
            image.flush();
            this.skin = outputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] getSkin() {
        return this.skin;
    }
}

