/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;

public class SkullCache {
    private final int maxVisibleSkulls;
    private final boolean cullingEnabled;
    private final int skullRenderDistanceSquared;
    private static final long CLEANUP_PERIOD = 10000L;
    private final Map<Vector3i, Skull> skulls = new Object2ObjectOpenHashMap();
    private final List<Skull> inRangeSkulls = new ArrayList<Skull>();
    private final Deque<SkullPlayerEntity> unusedSkullEntities = new ArrayDeque<SkullPlayerEntity>();
    private int totalSkullEntities = 0;
    private final GeyserSession session;
    private Vector3f lastPlayerPosition;
    private long lastCleanup = System.currentTimeMillis();

    public SkullCache(GeyserSession session) {
        this.session = session;
        this.maxVisibleSkulls = session.getGeyser().getConfig().getMaxVisibleCustomSkulls();
        this.cullingEnabled = this.maxVisibleSkulls != -1;
        int distance = Math.min(session.getGeyser().getConfig().getCustomSkullRenderDistance(), 64);
        this.skullRenderDistanceSquared = distance * distance;
    }

    public void putSkull(Vector3i position, String texturesProperty, int blockState) {
        Skull skull = this.skulls.computeIfAbsent(position, Skull::new);
        skull.texturesProperty = texturesProperty;
        skull.blockState = blockState;
        if (skull.entity != null) {
            skull.entity.updateSkull(skull);
        } else {
            if (!this.cullingEnabled) {
                this.assignSkullEntity(skull);
                return;
            }
            if (this.lastPlayerPosition == null) {
                return;
            }
            skull.distanceSquared = position.distanceSquared(this.lastPlayerPosition.getX(), this.lastPlayerPosition.getY(), this.lastPlayerPosition.getZ());
            if (skull.distanceSquared < this.skullRenderDistanceSquared) {
                int i = Collections.binarySearch(this.inRangeSkulls, skull, Comparator.comparingInt(Skull::getDistanceSquared));
                if (i < 0) {
                    i = -i - 1;
                }
                this.inRangeSkulls.add(i, skull);
                if (i < this.maxVisibleSkulls) {
                    if (this.inRangeSkulls.size() > this.maxVisibleSkulls) {
                        this.freeSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls));
                    }
                    this.assignSkullEntity(skull);
                }
            }
        }
    }

    public void removeSkull(Vector3i position) {
        Skull skull = this.skulls.remove(position);
        if (skull != null) {
            boolean hadEntity = skull.entity != null;
            this.freeSkullEntity(skull);
            if (this.cullingEnabled) {
                this.inRangeSkulls.remove(skull);
                if (hadEntity && this.inRangeSkulls.size() >= this.maxVisibleSkulls) {
                    this.assignSkullEntity(this.inRangeSkulls.get(this.maxVisibleSkulls - 1));
                }
            }
        }
    }

    public void updateVisibleSkulls() {
        if (this.cullingEnabled) {
            if (this.lastPlayerPosition != null && this.session.getPlayerEntity().getPosition().distanceSquared(this.lastPlayerPosition) < 4.0f) {
                return;
            }
            this.lastPlayerPosition = this.session.getPlayerEntity().getPosition();
            this.inRangeSkulls.clear();
            for (Skull skull : this.skulls.values()) {
                skull.distanceSquared = skull.position.distanceSquared(this.lastPlayerPosition.getX(), this.lastPlayerPosition.getY(), this.lastPlayerPosition.getZ());
                if (skull.distanceSquared > this.skullRenderDistanceSquared) {
                    this.freeSkullEntity(skull);
                    continue;
                }
                this.inRangeSkulls.add(skull);
            }
            this.inRangeSkulls.sort(Comparator.comparingInt(Skull::getDistanceSquared));
            for (int i = this.inRangeSkulls.size() - 1; i >= 0; --i) {
                if (i < this.maxVisibleSkulls) {
                    this.assignSkullEntity(this.inRangeSkulls.get(i));
                    continue;
                }
                this.freeSkullEntity(this.inRangeSkulls.get(i));
            }
        }
        if (System.currentTimeMillis() - this.lastCleanup > 10000L) {
            this.lastCleanup = System.currentTimeMillis();
            for (SkullPlayerEntity entity : this.unusedSkullEntities) {
                entity.despawnEntity();
                --this.totalSkullEntities;
            }
            this.unusedSkullEntities.clear();
        }
    }

    private void assignSkullEntity(Skull skull) {
        if (skull.entity != null) {
            return;
        }
        if (this.unusedSkullEntities.isEmpty()) {
            if (!this.cullingEnabled || this.totalSkullEntities < this.maxVisibleSkulls) {
                long geyserId = this.session.getEntityCache().getNextEntityId().incrementAndGet();
                skull.entity = new SkullPlayerEntity(this.session, geyserId);
                skull.entity.spawnEntity();
                skull.entity.updateSkull(skull);
                ++this.totalSkullEntities;
            }
        } else {
            skull.entity = this.unusedSkullEntities.removeFirst();
            skull.entity.updateSkull(skull);
        }
    }

    private void freeSkullEntity(Skull skull) {
        if (skull.entity != null) {
            skull.entity.free();
            this.unusedSkullEntities.addFirst(skull.entity);
            skull.entity = null;
        }
    }

    public void clear() {
        this.skulls.clear();
        this.inRangeSkulls.clear();
        this.unusedSkullEntities.clear();
        this.totalSkullEntities = 0;
        this.lastPlayerPosition = null;
    }

    public Map<Vector3i, Skull> getSkulls() {
        return this.skulls;
    }

    public static class Skull {
        private String texturesProperty;
        private int blockState;
        private SkullPlayerEntity entity;
        private final Vector3i position;
        private int distanceSquared;

        public Skull(Vector3i position) {
            this.position = position;
        }

        public String getTexturesProperty() {
            return this.texturesProperty;
        }

        public int getBlockState() {
            return this.blockState;
        }

        public SkullPlayerEntity getEntity() {
            return this.entity;
        }

        public Vector3i getPosition() {
            return this.position;
        }

        public int getDistanceSquared() {
            return this.distanceSquared;
        }

        public void setTexturesProperty(String texturesProperty) {
            this.texturesProperty = texturesProperty;
        }

        public void setBlockState(int blockState) {
            this.blockState = blockState;
        }

        public void setEntity(SkullPlayerEntity entity) {
            this.entity = entity;
        }

        public void setDistanceSquared(int distanceSquared) {
            this.distanceSquared = distanceSquared;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Skull)) {
                return false;
            }
            Skull other = (Skull)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBlockState() != other.getBlockState()) {
                return false;
            }
            if (this.getDistanceSquared() != other.getDistanceSquared()) {
                return false;
            }
            String this$texturesProperty = this.getTexturesProperty();
            String other$texturesProperty = other.getTexturesProperty();
            if (this$texturesProperty == null ? other$texturesProperty != null : !this$texturesProperty.equals(other$texturesProperty)) {
                return false;
            }
            SkullPlayerEntity this$entity = this.getEntity();
            SkullPlayerEntity other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            Vector3i this$position = this.getPosition();
            Vector3i other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Skull;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBlockState();
            result = result * 59 + this.getDistanceSquared();
            String $texturesProperty = this.getTexturesProperty();
            result = result * 59 + ($texturesProperty == null ? 43 : $texturesProperty.hashCode());
            SkullPlayerEntity $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            Vector3i $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
            return result;
        }

        public String toString() {
            return "SkullCache.Skull(texturesProperty=" + this.getTexturesProperty() + ", blockState=" + this.getBlockState() + ", entity=" + this.getEntity() + ", position=" + this.getPosition() + ", distanceSquared=" + this.getDistanceSquared() + ")";
        }
    }
}

