/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockServerSession;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import lombok.NonNull;

public class UpstreamSession {
    private final BedrockServerSession session;
    private boolean initialized = false;
    private Queue<BedrockPacket> postStartGamePackets = new ArrayDeque<BedrockPacket>();

    public void sendPacket(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (!this.isClosed()) {
            this.session.sendPacket(packet);
        }
    }

    public void sendPacketImmediately(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (!this.isClosed()) {
            this.session.sendPacketImmediately(packet);
        }
    }

    public void disconnect(String reason) {
        this.session.disconnect(reason);
    }

    public void queuePostStartGamePacket(BedrockPacket packet) {
        this.postStartGamePackets.add(packet);
    }

    public void sendPostStartGamePackets() {
        BedrockPacket packet;
        if (this.isClosed()) {
            return;
        }
        while ((packet = this.postStartGamePackets.poll()) != null) {
            this.session.sendPacket(packet);
        }
        this.postStartGamePackets = null;
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public InetSocketAddress getAddress() {
        return this.session.getRealAddress();
    }

    public int getProtocolVersion() {
        return this.session.getPacketCodec().getProtocolVersion();
    }

    public UpstreamSession(BedrockServerSession session) {
        this.session = session;
    }

    public BedrockServerSession getSession() {
        return this.session;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

