/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import com.github.steveice10.mc.protocol.data.game.scoreboard.NameTagVisibility;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamColor;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashSet;
import java.util.Set;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Score;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.UpdateType;

public final class Team {
    private final Scoreboard scoreboard;
    private final String id;
    private final Set<String> entities;
    private NameTagVisibility nameTagVisibility;
    private TeamColor color;
    private final TeamData currentData;
    private TeamData cachedData;
    private boolean updating;

    public Team(Scoreboard scoreboard, String id) {
        this.scoreboard = scoreboard;
        this.id = id;
        this.currentData = new TeamData();
        this.entities = new ObjectOpenHashSet();
    }

    public Set<String> addEntities(String ... names) {
        HashSet<String> added = new HashSet<String>();
        for (String name : names) {
            if (!this.entities.add(name)) continue;
            added.add(name);
        }
        if (added.isEmpty()) {
            return added;
        }
        for (Objective objective : this.scoreboard.getObjectives()) {
            for (String addedEntity : added) {
                Score score = objective.getScores().get(addedEntity);
                if (score == null) continue;
                score.setTeam(this);
            }
        }
        return added;
    }

    public Set<String> removeEntities(String ... names) {
        HashSet<String> removed = new HashSet<String>();
        for (String name : names) {
            if (!this.entities.remove(name)) continue;
            removed.add(name);
        }
        return removed;
    }

    public boolean hasEntity(String name) {
        return this.entities.contains(name);
    }

    public Team setName(String name) {
        this.currentData.name = name;
        return this;
    }

    public Team setPrefix(String prefix) {
        if (prefix.length() == 4 && "null".equals(prefix)) {
            this.currentData.prefix = "";
            return this;
        }
        this.currentData.prefix = prefix;
        return this;
    }

    public Team setSuffix(String suffix) {
        if (suffix.length() == 4 && "null".equals(suffix)) {
            this.currentData.suffix = "";
            return this;
        }
        this.currentData.suffix = suffix;
        return this;
    }

    public String getDisplayName(String score) {
        return this.cachedData != null ? this.cachedData.getDisplayName(score) : this.currentData.getDisplayName(score);
    }

    public void markUpdated() {
        this.updating = false;
    }

    public boolean shouldUpdate() {
        return this.updating || this.cachedData == null || this.currentData.changed;
    }

    public void prepareUpdate() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        if (this.cachedData == null) {
            this.cachedData = new TeamData();
            this.cachedData.updateType = this.currentData.updateType != UpdateType.REMOVE ? UpdateType.ADD : UpdateType.REMOVE;
        } else {
            this.cachedData.updateType = this.currentData.updateType;
        }
        this.currentData.changed = false;
        this.cachedData.name = this.currentData.name;
        this.cachedData.prefix = this.currentData.prefix;
        this.cachedData.suffix = this.currentData.suffix;
    }

    public UpdateType getUpdateType() {
        return this.currentData.updateType;
    }

    public UpdateType getCachedUpdateType() {
        return this.cachedData != null ? this.cachedData.updateType : this.currentData.updateType;
    }

    public Team setUpdateType(UpdateType updateType) {
        if (updateType != UpdateType.NOTHING) {
            this.currentData.changed = true;
        }
        this.currentData.updateType = updateType;
        return this;
    }

    public boolean isVisibleFor(String entity) {
        return switch (this.nameTagVisibility) {
            case NameTagVisibility.HIDE_FOR_OTHER_TEAMS -> {
                Team team = this.scoreboard.getTeamFor(entity);
                if (team == null || team == this) {
                    yield true;
                }
                yield false;
            }
            case NameTagVisibility.HIDE_FOR_OWN_TEAM -> {
                if (!this.hasEntity(entity)) {
                    yield true;
                }
                yield false;
            }
            case NameTagVisibility.ALWAYS -> true;
            case NameTagVisibility.NEVER -> false;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public String getId() {
        return this.id;
    }

    public NameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    public TeamColor getColor() {
        return this.color;
    }

    public TeamData getCurrentData() {
        return this.currentData;
    }

    public TeamData getCachedData() {
        return this.cachedData;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    Set<String> getEntities() {
        return this.entities;
    }

    public Team setNameTagVisibility(NameTagVisibility nameTagVisibility) {
        this.nameTagVisibility = nameTagVisibility;
        return this;
    }

    public Team setColor(TeamColor color) {
        this.color = color;
        return this;
    }

    public static final class TeamData {
        private UpdateType updateType = UpdateType.ADD;
        private boolean changed;
        private String name;
        private String prefix;
        private String suffix;

        private TeamData() {
        }

        public String getDisplayName(String score) {
            return this.prefix + score + this.suffix;
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

