/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.nukkitx.protocol.bedrock.data.inventory.ComponentItemData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.registry.type.ItemMapping;

public final class ItemMappings {
    private final Map<String, ItemMapping> cachedJavaMappings = new WeakHashMap<String, ItemMapping>();
    private final ItemMapping[] items;
    private final ItemMapping lodestoneCompass;
    private final ItemData[] creativeItems;
    private final List<StartGamePacket.ItemEntry> itemEntries;
    private final StoredItemMappings storedItems;
    private final String[] itemNames;
    private final Set<String> javaOnlyItems;
    private final IntList bucketIds;
    private final IntList boatIds;
    private final IntList spawnEggIds;
    private final List<ItemData> carpets;
    @Nullable
    private final ComponentItemData furnaceMinecartData;

    @Nonnull
    public ItemMapping getMapping(ItemStack itemStack) {
        return this.getMapping(itemStack.getId());
    }

    @Nonnull
    public ItemMapping getMapping(int javaId) {
        return javaId >= 0 && javaId < this.items.length ? this.items[javaId] : ItemMapping.AIR;
    }

    public ItemMapping getMapping(String javaIdentifier) {
        return this.cachedJavaMappings.computeIfAbsent(javaIdentifier, key -> {
            for (ItemMapping mapping : this.items) {
                if (!mapping.getJavaIdentifier().equals(key)) continue;
                return mapping;
            }
            return null;
        });
    }

    public ItemMapping getMapping(ItemData data) {
        int id = data.getId();
        if (id == 0) {
            return ItemMapping.AIR;
        }
        if (id == this.lodestoneCompass.getBedrockId()) {
            return this.lodestoneCompass;
        }
        boolean isBlock = data.getBlockRuntimeId() != 0;
        boolean hasDamage = data.getDamage() != 0;
        for (ItemMapping mapping : this.items) {
            if (mapping.getBedrockId() != id || (!isBlock || hasDamage ? mapping.getBedrockData() != data.getDamage() && !mapping.getJavaIdentifier().endsWith("potion") && !mapping.getJavaIdentifier().equals("minecraft:arrow") && !mapping.getJavaIdentifier().equals("minecraft:firework_star") && !mapping.getJavaIdentifier().equals("minecraft:goat_horn") : data.getBlockRuntimeId() != mapping.getBedrockBlockId())) continue;
            if (this.javaOnlyItems.contains(mapping.getJavaIdentifier())) continue;
            return mapping;
        }
        if (id != 0 && data.getDamage() != 0) {
            GeyserImpl.getInstance().getLogger().debug("Missing mapping for bedrock item " + data.getId() + ":" + data.getDamage());
        }
        return ItemMapping.AIR;
    }

    ItemMappings(ItemMapping[] items, ItemMapping lodestoneCompass, ItemData[] creativeItems, List<StartGamePacket.ItemEntry> itemEntries, StoredItemMappings storedItems, String[] itemNames, Set<String> javaOnlyItems, IntList bucketIds, IntList boatIds, IntList spawnEggIds, List<ItemData> carpets, @Nullable ComponentItemData furnaceMinecartData) {
        this.items = items;
        this.lodestoneCompass = lodestoneCompass;
        this.creativeItems = creativeItems;
        this.itemEntries = itemEntries;
        this.storedItems = storedItems;
        this.itemNames = itemNames;
        this.javaOnlyItems = javaOnlyItems;
        this.bucketIds = bucketIds;
        this.boatIds = boatIds;
        this.spawnEggIds = spawnEggIds;
        this.carpets = carpets;
        this.furnaceMinecartData = furnaceMinecartData;
    }

    public static ItemMappingsBuilder builder() {
        return new ItemMappingsBuilder();
    }

    public Map<String, ItemMapping> getCachedJavaMappings() {
        return this.cachedJavaMappings;
    }

    public ItemMapping[] getItems() {
        return this.items;
    }

    public ItemMapping getLodestoneCompass() {
        return this.lodestoneCompass;
    }

    public ItemData[] getCreativeItems() {
        return this.creativeItems;
    }

    public List<StartGamePacket.ItemEntry> getItemEntries() {
        return this.itemEntries;
    }

    public StoredItemMappings getStoredItems() {
        return this.storedItems;
    }

    public String[] getItemNames() {
        return this.itemNames;
    }

    public Set<String> getJavaOnlyItems() {
        return this.javaOnlyItems;
    }

    public IntList getBucketIds() {
        return this.bucketIds;
    }

    public IntList getBoatIds() {
        return this.boatIds;
    }

    public IntList getSpawnEggIds() {
        return this.spawnEggIds;
    }

    public List<ItemData> getCarpets() {
        return this.carpets;
    }

    @Nullable
    public ComponentItemData getFurnaceMinecartData() {
        return this.furnaceMinecartData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemMappings)) {
            return false;
        }
        ItemMappings other = (ItemMappings)o;
        Map<String, ItemMapping> this$cachedJavaMappings = this.getCachedJavaMappings();
        Map<String, ItemMapping> other$cachedJavaMappings = other.getCachedJavaMappings();
        if (this$cachedJavaMappings == null ? other$cachedJavaMappings != null : !((Object)this$cachedJavaMappings).equals(other$cachedJavaMappings)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        ItemMapping this$lodestoneCompass = this.getLodestoneCompass();
        ItemMapping other$lodestoneCompass = other.getLodestoneCompass();
        if (this$lodestoneCompass == null ? other$lodestoneCompass != null : !((Object)this$lodestoneCompass).equals(other$lodestoneCompass)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCreativeItems(), other.getCreativeItems())) {
            return false;
        }
        List<StartGamePacket.ItemEntry> this$itemEntries = this.getItemEntries();
        List<StartGamePacket.ItemEntry> other$itemEntries = other.getItemEntries();
        if (this$itemEntries == null ? other$itemEntries != null : !((Object)this$itemEntries).equals(other$itemEntries)) {
            return false;
        }
        StoredItemMappings this$storedItems = this.getStoredItems();
        StoredItemMappings other$storedItems = other.getStoredItems();
        if (this$storedItems == null ? other$storedItems != null : !this$storedItems.equals(other$storedItems)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItemNames(), other.getItemNames())) {
            return false;
        }
        Set<String> this$javaOnlyItems = this.getJavaOnlyItems();
        Set<String> other$javaOnlyItems = other.getJavaOnlyItems();
        if (this$javaOnlyItems == null ? other$javaOnlyItems != null : !((Object)this$javaOnlyItems).equals(other$javaOnlyItems)) {
            return false;
        }
        IntList this$bucketIds = this.getBucketIds();
        IntList other$bucketIds = other.getBucketIds();
        if (this$bucketIds == null ? other$bucketIds != null : !this$bucketIds.equals(other$bucketIds)) {
            return false;
        }
        IntList this$boatIds = this.getBoatIds();
        IntList other$boatIds = other.getBoatIds();
        if (this$boatIds == null ? other$boatIds != null : !this$boatIds.equals(other$boatIds)) {
            return false;
        }
        IntList this$spawnEggIds = this.getSpawnEggIds();
        IntList other$spawnEggIds = other.getSpawnEggIds();
        if (this$spawnEggIds == null ? other$spawnEggIds != null : !this$spawnEggIds.equals(other$spawnEggIds)) {
            return false;
        }
        List<ItemData> this$carpets = this.getCarpets();
        List<ItemData> other$carpets = other.getCarpets();
        if (this$carpets == null ? other$carpets != null : !((Object)this$carpets).equals(other$carpets)) {
            return false;
        }
        ComponentItemData this$furnaceMinecartData = this.getFurnaceMinecartData();
        ComponentItemData other$furnaceMinecartData = other.getFurnaceMinecartData();
        return !(this$furnaceMinecartData == null ? other$furnaceMinecartData != null : !((Object)this$furnaceMinecartData).equals(other$furnaceMinecartData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ItemMapping> $cachedJavaMappings = this.getCachedJavaMappings();
        result = result * 59 + ($cachedJavaMappings == null ? 43 : ((Object)$cachedJavaMappings).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        ItemMapping $lodestoneCompass = this.getLodestoneCompass();
        result = result * 59 + ($lodestoneCompass == null ? 43 : ((Object)$lodestoneCompass).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCreativeItems());
        List<StartGamePacket.ItemEntry> $itemEntries = this.getItemEntries();
        result = result * 59 + ($itemEntries == null ? 43 : ((Object)$itemEntries).hashCode());
        StoredItemMappings $storedItems = this.getStoredItems();
        result = result * 59 + ($storedItems == null ? 43 : $storedItems.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItemNames());
        Set<String> $javaOnlyItems = this.getJavaOnlyItems();
        result = result * 59 + ($javaOnlyItems == null ? 43 : ((Object)$javaOnlyItems).hashCode());
        IntList $bucketIds = this.getBucketIds();
        result = result * 59 + ($bucketIds == null ? 43 : $bucketIds.hashCode());
        IntList $boatIds = this.getBoatIds();
        result = result * 59 + ($boatIds == null ? 43 : $boatIds.hashCode());
        IntList $spawnEggIds = this.getSpawnEggIds();
        result = result * 59 + ($spawnEggIds == null ? 43 : $spawnEggIds.hashCode());
        List<ItemData> $carpets = this.getCarpets();
        result = result * 59 + ($carpets == null ? 43 : ((Object)$carpets).hashCode());
        ComponentItemData $furnaceMinecartData = this.getFurnaceMinecartData();
        result = result * 59 + ($furnaceMinecartData == null ? 43 : ((Object)$furnaceMinecartData).hashCode());
        return result;
    }

    public String toString() {
        return "ItemMappings(cachedJavaMappings=" + this.getCachedJavaMappings() + ", items=" + Arrays.deepToString(this.getItems()) + ", lodestoneCompass=" + this.getLodestoneCompass() + ", creativeItems=" + Arrays.deepToString(this.getCreativeItems()) + ", itemEntries=" + this.getItemEntries() + ", storedItems=" + this.getStoredItems() + ", itemNames=" + Arrays.deepToString(this.getItemNames()) + ", javaOnlyItems=" + this.getJavaOnlyItems() + ", bucketIds=" + this.getBucketIds() + ", boatIds=" + this.getBoatIds() + ", spawnEggIds=" + this.getSpawnEggIds() + ", carpets=" + this.getCarpets() + ", furnaceMinecartData=" + this.getFurnaceMinecartData() + ")";
    }

    public static class ItemMappingsBuilder {
        private ItemMapping[] items;
        private ItemMapping lodestoneCompass;
        private ItemData[] creativeItems;
        private List<StartGamePacket.ItemEntry> itemEntries;
        private StoredItemMappings storedItems;
        private String[] itemNames;
        private Set<String> javaOnlyItems;
        private IntList bucketIds;
        private IntList boatIds;
        private IntList spawnEggIds;
        private List<ItemData> carpets;
        private ComponentItemData furnaceMinecartData;

        ItemMappingsBuilder() {
        }

        public ItemMappingsBuilder items(ItemMapping[] items) {
            this.items = items;
            return this;
        }

        public ItemMappingsBuilder lodestoneCompass(ItemMapping lodestoneCompass) {
            this.lodestoneCompass = lodestoneCompass;
            return this;
        }

        public ItemMappingsBuilder creativeItems(ItemData[] creativeItems) {
            this.creativeItems = creativeItems;
            return this;
        }

        public ItemMappingsBuilder itemEntries(List<StartGamePacket.ItemEntry> itemEntries) {
            this.itemEntries = itemEntries;
            return this;
        }

        public ItemMappingsBuilder storedItems(StoredItemMappings storedItems) {
            this.storedItems = storedItems;
            return this;
        }

        public ItemMappingsBuilder itemNames(String[] itemNames) {
            this.itemNames = itemNames;
            return this;
        }

        public ItemMappingsBuilder javaOnlyItems(Set<String> javaOnlyItems) {
            this.javaOnlyItems = javaOnlyItems;
            return this;
        }

        public ItemMappingsBuilder bucketIds(IntList bucketIds) {
            this.bucketIds = bucketIds;
            return this;
        }

        public ItemMappingsBuilder boatIds(IntList boatIds) {
            this.boatIds = boatIds;
            return this;
        }

        public ItemMappingsBuilder spawnEggIds(IntList spawnEggIds) {
            this.spawnEggIds = spawnEggIds;
            return this;
        }

        public ItemMappingsBuilder carpets(List<ItemData> carpets) {
            this.carpets = carpets;
            return this;
        }

        public ItemMappingsBuilder furnaceMinecartData(@Nullable ComponentItemData furnaceMinecartData) {
            this.furnaceMinecartData = furnaceMinecartData;
            return this;
        }

        public ItemMappings build() {
            return new ItemMappings(this.items, this.lodestoneCompass, this.creativeItems, this.itemEntries, this.storedItems, this.itemNames, this.javaOnlyItems, this.bucketIds, this.boatIds, this.spawnEggIds, this.carpets, this.furnaceMinecartData);
        }

        public String toString() {
            return "ItemMappings.ItemMappingsBuilder(items=" + Arrays.deepToString(this.items) + ", lodestoneCompass=" + this.lodestoneCompass + ", creativeItems=" + Arrays.deepToString(this.creativeItems) + ", itemEntries=" + this.itemEntries + ", storedItems=" + this.storedItems + ", itemNames=" + Arrays.deepToString(this.itemNames) + ", javaOnlyItems=" + this.javaOnlyItems + ", bucketIds=" + this.bucketIds + ", boatIds=" + this.boatIds + ", spawnEggIds=" + this.spawnEggIds + ", carpets=" + this.carpets + ", furnaceMinecartData=" + this.furnaceMinecartData + ")";
        }
    }
}

