/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import com.nukkitx.nbt.NbtList;
import com.nukkitx.nbt.NbtMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.Map;

public final class BlockMappings {
    private final int bedrockAirId;
    private final int bedrockWaterId;
    private final int bedrockMovingBlockId;
    private final int blockStateVersion;
    private final int[] javaToBedrockBlocks;
    private final NbtList<NbtMap> bedrockBlockStates;
    private final int commandBlockRuntimeId;
    private final Object2IntMap<NbtMap> itemFrames;
    private final Map<String, NbtMap> flowerPotBlocks;
    private final IntSet jigsawStateIds;

    public int getBedrockBlockId(int state) {
        if (state >= this.javaToBedrockBlocks.length) {
            return this.bedrockAirId;
        }
        return this.javaToBedrockBlocks[state];
    }

    public int getItemFrame(NbtMap tag) {
        return this.itemFrames.getOrDefault((Object)tag, -1);
    }

    public boolean isItemFrame(int bedrockBlockRuntimeId) {
        return this.itemFrames.values().contains(bedrockBlockRuntimeId);
    }

    BlockMappings(int bedrockAirId, int bedrockWaterId, int bedrockMovingBlockId, int blockStateVersion, int[] javaToBedrockBlocks, NbtList<NbtMap> bedrockBlockStates, int commandBlockRuntimeId, Object2IntMap<NbtMap> itemFrames, Map<String, NbtMap> flowerPotBlocks, IntSet jigsawStateIds) {
        this.bedrockAirId = bedrockAirId;
        this.bedrockWaterId = bedrockWaterId;
        this.bedrockMovingBlockId = bedrockMovingBlockId;
        this.blockStateVersion = blockStateVersion;
        this.javaToBedrockBlocks = javaToBedrockBlocks;
        this.bedrockBlockStates = bedrockBlockStates;
        this.commandBlockRuntimeId = commandBlockRuntimeId;
        this.itemFrames = itemFrames;
        this.flowerPotBlocks = flowerPotBlocks;
        this.jigsawStateIds = jigsawStateIds;
    }

    public static BlockMappingsBuilder builder() {
        return new BlockMappingsBuilder();
    }

    public int getBedrockAirId() {
        return this.bedrockAirId;
    }

    public int getBedrockWaterId() {
        return this.bedrockWaterId;
    }

    public int getBedrockMovingBlockId() {
        return this.bedrockMovingBlockId;
    }

    public int getBlockStateVersion() {
        return this.blockStateVersion;
    }

    public int[] getJavaToBedrockBlocks() {
        return this.javaToBedrockBlocks;
    }

    public NbtList<NbtMap> getBedrockBlockStates() {
        return this.bedrockBlockStates;
    }

    public int getCommandBlockRuntimeId() {
        return this.commandBlockRuntimeId;
    }

    public Object2IntMap<NbtMap> getItemFrames() {
        return this.itemFrames;
    }

    public Map<String, NbtMap> getFlowerPotBlocks() {
        return this.flowerPotBlocks;
    }

    public IntSet getJigsawStateIds() {
        return this.jigsawStateIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockMappings)) {
            return false;
        }
        BlockMappings other = (BlockMappings)o;
        if (this.getBedrockAirId() != other.getBedrockAirId()) {
            return false;
        }
        if (this.getBedrockWaterId() != other.getBedrockWaterId()) {
            return false;
        }
        if (this.getBedrockMovingBlockId() != other.getBedrockMovingBlockId()) {
            return false;
        }
        if (this.getBlockStateVersion() != other.getBlockStateVersion()) {
            return false;
        }
        if (this.getCommandBlockRuntimeId() != other.getCommandBlockRuntimeId()) {
            return false;
        }
        if (!Arrays.equals(this.getJavaToBedrockBlocks(), other.getJavaToBedrockBlocks())) {
            return false;
        }
        NbtList<NbtMap> this$bedrockBlockStates = this.getBedrockBlockStates();
        NbtList<NbtMap> other$bedrockBlockStates = other.getBedrockBlockStates();
        if (this$bedrockBlockStates == null ? other$bedrockBlockStates != null : !((Object)this$bedrockBlockStates).equals(other$bedrockBlockStates)) {
            return false;
        }
        Object2IntMap<NbtMap> this$itemFrames = this.getItemFrames();
        Object2IntMap<NbtMap> other$itemFrames = other.getItemFrames();
        if (this$itemFrames == null ? other$itemFrames != null : !this$itemFrames.equals(other$itemFrames)) {
            return false;
        }
        Map<String, NbtMap> this$flowerPotBlocks = this.getFlowerPotBlocks();
        Map<String, NbtMap> other$flowerPotBlocks = other.getFlowerPotBlocks();
        if (this$flowerPotBlocks == null ? other$flowerPotBlocks != null : !((Object)this$flowerPotBlocks).equals(other$flowerPotBlocks)) {
            return false;
        }
        IntSet this$jigsawStateIds = this.getJigsawStateIds();
        IntSet other$jigsawStateIds = other.getJigsawStateIds();
        return !(this$jigsawStateIds == null ? other$jigsawStateIds != null : !this$jigsawStateIds.equals(other$jigsawStateIds));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBedrockAirId();
        result = result * 59 + this.getBedrockWaterId();
        result = result * 59 + this.getBedrockMovingBlockId();
        result = result * 59 + this.getBlockStateVersion();
        result = result * 59 + this.getCommandBlockRuntimeId();
        result = result * 59 + Arrays.hashCode(this.getJavaToBedrockBlocks());
        NbtList<NbtMap> $bedrockBlockStates = this.getBedrockBlockStates();
        result = result * 59 + ($bedrockBlockStates == null ? 43 : ((Object)$bedrockBlockStates).hashCode());
        Object2IntMap<NbtMap> $itemFrames = this.getItemFrames();
        result = result * 59 + ($itemFrames == null ? 43 : $itemFrames.hashCode());
        Map<String, NbtMap> $flowerPotBlocks = this.getFlowerPotBlocks();
        result = result * 59 + ($flowerPotBlocks == null ? 43 : ((Object)$flowerPotBlocks).hashCode());
        IntSet $jigsawStateIds = this.getJigsawStateIds();
        result = result * 59 + ($jigsawStateIds == null ? 43 : $jigsawStateIds.hashCode());
        return result;
    }

    public String toString() {
        return "BlockMappings(bedrockAirId=" + this.getBedrockAirId() + ", bedrockWaterId=" + this.getBedrockWaterId() + ", bedrockMovingBlockId=" + this.getBedrockMovingBlockId() + ", blockStateVersion=" + this.getBlockStateVersion() + ", javaToBedrockBlocks=" + Arrays.toString(this.getJavaToBedrockBlocks()) + ", bedrockBlockStates=" + this.getBedrockBlockStates() + ", commandBlockRuntimeId=" + this.getCommandBlockRuntimeId() + ", itemFrames=" + this.getItemFrames() + ", flowerPotBlocks=" + this.getFlowerPotBlocks() + ", jigsawStateIds=" + this.getJigsawStateIds() + ")";
    }

    public static class BlockMappingsBuilder {
        private int bedrockAirId;
        private int bedrockWaterId;
        private int bedrockMovingBlockId;
        private int blockStateVersion;
        private int[] javaToBedrockBlocks;
        private NbtList<NbtMap> bedrockBlockStates;
        private int commandBlockRuntimeId;
        private Object2IntMap<NbtMap> itemFrames;
        private Map<String, NbtMap> flowerPotBlocks;
        private IntSet jigsawStateIds;

        BlockMappingsBuilder() {
        }

        public BlockMappingsBuilder bedrockAirId(int bedrockAirId) {
            this.bedrockAirId = bedrockAirId;
            return this;
        }

        public BlockMappingsBuilder bedrockWaterId(int bedrockWaterId) {
            this.bedrockWaterId = bedrockWaterId;
            return this;
        }

        public BlockMappingsBuilder bedrockMovingBlockId(int bedrockMovingBlockId) {
            this.bedrockMovingBlockId = bedrockMovingBlockId;
            return this;
        }

        public BlockMappingsBuilder blockStateVersion(int blockStateVersion) {
            this.blockStateVersion = blockStateVersion;
            return this;
        }

        public BlockMappingsBuilder javaToBedrockBlocks(int[] javaToBedrockBlocks) {
            this.javaToBedrockBlocks = javaToBedrockBlocks;
            return this;
        }

        public BlockMappingsBuilder bedrockBlockStates(NbtList<NbtMap> bedrockBlockStates) {
            this.bedrockBlockStates = bedrockBlockStates;
            return this;
        }

        public BlockMappingsBuilder commandBlockRuntimeId(int commandBlockRuntimeId) {
            this.commandBlockRuntimeId = commandBlockRuntimeId;
            return this;
        }

        public BlockMappingsBuilder itemFrames(Object2IntMap<NbtMap> itemFrames) {
            this.itemFrames = itemFrames;
            return this;
        }

        public BlockMappingsBuilder flowerPotBlocks(Map<String, NbtMap> flowerPotBlocks) {
            this.flowerPotBlocks = flowerPotBlocks;
            return this;
        }

        public BlockMappingsBuilder jigsawStateIds(IntSet jigsawStateIds) {
            this.jigsawStateIds = jigsawStateIds;
            return this;
        }

        public BlockMappings build() {
            return new BlockMappings(this.bedrockAirId, this.bedrockWaterId, this.bedrockMovingBlockId, this.blockStateVersion, this.javaToBedrockBlocks, this.bedrockBlockStates, this.commandBlockRuntimeId, this.itemFrames, this.flowerPotBlocks, this.jigsawStateIds);
        }

        public String toString() {
            return "BlockMappings.BlockMappingsBuilder(bedrockAirId=" + this.bedrockAirId + ", bedrockWaterId=" + this.bedrockWaterId + ", bedrockMovingBlockId=" + this.bedrockMovingBlockId + ", blockStateVersion=" + this.blockStateVersion + ", javaToBedrockBlocks=" + Arrays.toString(this.javaToBedrockBlocks) + ", bedrockBlockStates=" + this.bedrockBlockStates + ", commandBlockRuntimeId=" + this.commandBlockRuntimeId + ", itemFrames=" + this.itemFrames + ", flowerPotBlocks=" + this.flowerPotBlocks + ", jigsawStateIds=" + this.jigsawStateIds + ")";
        }
    }
}

