/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.data.game.recipe.RecipeType;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class RecipeRegistryPopulator {
    public static void populate() {
        JsonNode items;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource("mappings/recipes.json");){
            items = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError(GeyserLocale.getLocaleStringLog("geyser.toolbox.fail.runtime_java", new Object[0]), e);
        }
        int currentRecipeId = InventoryUtils.LAST_RECIPE_NET_ID;
        for (Int2ObjectMap.Entry version : ((Int2ObjectMap)Registries.ITEMS.get()).int2ObjectEntrySet()) {
            InventoryUtils.LAST_RECIPE_NET_ID = currentRecipeId;
            EnumMap<RecipeType, List> craftingData = new EnumMap<RecipeType, List>(RecipeType.class);
            Int2ObjectOpenHashMap recipes = new Int2ObjectOpenHashMap();
            craftingData.put(RecipeType.CRAFTING_SPECIAL_BOOKCLONING, Collections.singletonList(CraftingData.fromMulti(UUID.fromString("d1ca6b84-338e-4f2f-9c6b-76cc8b4bd98d"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            craftingData.put(RecipeType.CRAFTING_SPECIAL_REPAIRITEM, Collections.singletonList(CraftingData.fromMulti(UUID.fromString("00000000-0000-0000-0000-000000000001"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            craftingData.put(RecipeType.CRAFTING_SPECIAL_MAPEXTENDING, Collections.singletonList(CraftingData.fromMulti(UUID.fromString("d392b075-4ba1-40ae-8789-af868d56f6ce"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            craftingData.put(RecipeType.CRAFTING_SPECIAL_MAPCLONING, Collections.singletonList(CraftingData.fromMulti(UUID.fromString("85939755-ba10-4d9d-a4cc-efb7a8e943c4"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            craftingData.put(RecipeType.CRAFTING_SPECIAL_BANNERADDPATTERN, Collections.singletonList(CraftingData.fromMulti(UUID.fromString("b5c5d105-75a2-4076-af2b-923ea2bf4bf0"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            for (JsonNode entry : items.get("leather_armor")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_ARMORDYE, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry, (Int2ObjectMap<GeyserRecipe>)recipes, (ItemMappings)version.getValue()));
            }
            for (JsonNode entry : items.get("firework_rockets")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_FIREWORK_ROCKET, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry, (Int2ObjectMap<GeyserRecipe>)recipes, (ItemMappings)version.getValue()));
            }
            for (JsonNode entry : items.get("firework_stars")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_FIREWORK_STAR, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry, (Int2ObjectMap<GeyserRecipe>)recipes, (ItemMappings)version.getValue()));
            }
            for (JsonNode entry : items.get("shulker_boxes")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_SHULKERBOXCOLORING, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry, (Int2ObjectMap<GeyserRecipe>)recipes, (ItemMappings)version.getValue()));
            }
            for (JsonNode entry : items.get("suspicious_stew")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_SUSPICIOUSSTEW, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry, (Int2ObjectMap<GeyserRecipe>)recipes, (ItemMappings)version.getValue()));
            }
            for (JsonNode entry : items.get("tipped_arrows")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_TIPPEDARROW, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry, (Int2ObjectMap<GeyserRecipe>)recipes, (ItemMappings)version.getValue()));
            }
            Registries.CRAFTING_DATA.register(version.getIntKey(), craftingData);
            Registries.RECIPES.register(version.getIntKey(), (Int2ObjectMap<GeyserRecipe>)recipes);
        }
    }

    private static CraftingData getCraftingDataFromJsonNode(JsonNode node, Int2ObjectMap<GeyserRecipe> recipes, ItemMappings mappings) {
        int netId = ++InventoryUtils.LAST_RECIPE_NET_ID;
        int type = node.get("bedrockRecipeType").asInt();
        JsonNode outputNode = node.get("output");
        ItemMapping outputEntry = mappings.getMapping(outputNode.get("identifier").asText());
        ItemData output = RecipeRegistryPopulator.getBedrockItemFromIdentifierJson(outputEntry, outputNode);
        UUID uuid = UUID.randomUUID();
        if (type == 1) {
            ArrayList<String> shape = new ArrayList<String>();
            for (JsonNode chars : node.get("shape")) {
                shape.add(chars.asText());
            }
            HashMap<String, ItemData> letterToRecipe = new HashMap<String, ItemData>();
            Iterator<Map.Entry<String, JsonNode>> iterator = node.get("inputs").fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                JsonNode inputNode = entry.getValue();
                ItemMapping inputEntry = mappings.getMapping(inputNode.get("identifier").asText());
                letterToRecipe.put(entry.getKey(), RecipeRegistryPopulator.getBedrockItemFromIdentifierJson(inputEntry, inputNode));
            }
            ArrayList<ItemData> inputs = new ArrayList<ItemData>(shape.size() * ((String)shape.get(0)).length());
            int i = 0;
            int j = 0;
            while (i < shape.size() * ((String)shape.get(0)).length()) {
                for (char c : ((String)shape.get(j)).toCharArray()) {
                    ItemData data = letterToRecipe.getOrDefault(String.valueOf(c), ItemData.AIR);
                    inputs.add(data);
                    ++i;
                }
                ++j;
            }
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            Object object = inputs.iterator();
            while (object.hasNext()) {
                ItemData input = (ItemData)object.next();
                ingredients.add(new Ingredient(new ItemStack[]{ItemTranslator.translateToJava(input, mappings)}));
            }
            GeyserShapedRecipe recipe = new GeyserShapedRecipe(((String)shape.get(0)).length(), shape.size(), ingredients.toArray(new Ingredient[0]), ItemTranslator.translateToJava(output, mappings));
            recipes.put(netId, (Object)recipe);
            return CraftingData.fromShaped(uuid.toString(), ((String)shape.get(0)).length(), shape.size(), inputs, Collections.singletonList(output), uuid, "crafting_table", 0, netId);
        }
        ObjectArrayList inputs = new ObjectArrayList();
        for (Object entry : node.get("inputs")) {
            ItemMapping inputEntry = mappings.getMapping(((JsonNode)entry).get("identifier").asText());
            inputs.add(RecipeRegistryPopulator.getBedrockItemFromIdentifierJson(inputEntry, (JsonNode)entry));
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (ItemData input : inputs) {
            ingredients.add(new Ingredient(new ItemStack[]{ItemTranslator.translateToJava(input, mappings)}));
        }
        GeyserShapelessRecipe recipe = new GeyserShapelessRecipe(ingredients.toArray(new Ingredient[0]), ItemTranslator.translateToJava(output, mappings));
        recipes.put(netId, (Object)recipe);
        if (type == 5) {
            return CraftingData.fromShulkerBox(uuid.toString(), (List<ItemData>)inputs, Collections.singletonList(output), uuid, "crafting_table", 0, netId);
        }
        return CraftingData.fromShapeless(uuid.toString(), (List<ItemData>)inputs, Collections.singletonList(output), uuid, "crafting_table", 0, netId);
    }

    private static ItemData getBedrockItemFromIdentifierJson(ItemMapping mapping, JsonNode itemNode) {
        JsonNode nbtNode;
        JsonNode countNode;
        int count = 1;
        short damage = 0;
        NbtMap tag = null;
        JsonNode damageNode = itemNode.get("bedrockDamage");
        if (damageNode != null) {
            damage = damageNode.numberValue().shortValue();
        }
        if ((countNode = itemNode.get("count")) != null) {
            count = countNode.asInt();
        }
        if ((nbtNode = itemNode.get("bedrockNbt")) != null) {
            byte[] bytes = Base64.getDecoder().decode(nbtNode.asText());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                tag = (NbtMap)NbtUtils.createReaderLE(bais).readTag();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ItemData.builder().id(mapping.getBedrockId()).damage(damage).count(count).blockRuntimeId(mapping.isBlock() ? mapping.getBedrockBlockId() : 0).tag(tag).build();
    }
}

