/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.relocate.jackson.databind.JsonNode;

public abstract class EffectRegistryLoader<T>
implements RegistryLoader<String, T> {
    private static final Map<String, JsonNode> loadedFiles = new WeakHashMap<String, JsonNode>();

    public void loadFile(String input) {
        if (!loadedFiles.containsKey(input)) {
            JsonNode effects;
            try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource(input);){
                effects = GeyserImpl.JSON_MAPPER.readTree(stream);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load registrations for " + input, e);
            }
            loadedFiles.put(input, effects);
        }
    }

    public JsonNode get(String input) {
        return loadedFiles.get(input);
    }
}

