/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.geysermc.relocate.jackson.annotation.JsonProperty;

public class ResourcePackManifest {
    @JsonProperty(value="format_version")
    private Integer formatVersion;
    private Header header;
    private Collection<Module> modules;
    protected Collection<Dependency> dependencies;

    public Collection<Module> getModules() {
        return Collections.unmodifiableCollection(this.modules);
    }

    public Integer getFormatVersion() {
        return this.formatVersion;
    }

    public Header getHeader() {
        return this.header;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePackManifest)) {
            return false;
        }
        ResourcePackManifest other = (ResourcePackManifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$formatVersion = this.getFormatVersion();
        Integer other$formatVersion = other.getFormatVersion();
        if (this$formatVersion == null ? other$formatVersion != null : !((Object)this$formatVersion).equals(other$formatVersion)) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Collection<Module> this$modules = this.getModules();
        Collection<Module> other$modules = other.getModules();
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        Collection<Dependency> this$dependencies = this.getDependencies();
        Collection<Dependency> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourcePackManifest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $formatVersion = this.getFormatVersion();
        result = result * 59 + ($formatVersion == null ? 43 : ((Object)$formatVersion).hashCode());
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Collection<Module> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        Collection<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    public static class Header {
        private String description;
        private String name;
        private UUID uuid;
        private int[] version;
        @JsonProperty(value="min_engine_version")
        private int[] minimumSupportedMinecraftVersion;

        public String getVersionString() {
            return this.version[0] + "." + this.version[1] + "." + this.version[2];
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public int[] getVersion() {
            return this.version;
        }

        public int[] getMinimumSupportedMinecraftVersion() {
            return this.minimumSupportedMinecraftVersion;
        }

        public String toString() {
            return "ResourcePackManifest.Header(description=" + this.getDescription() + ", name=" + this.getName() + ", uuid=" + this.getUuid() + ", version=" + Arrays.toString(this.getVersion()) + ", minimumSupportedMinecraftVersion=" + Arrays.toString(this.getMinimumSupportedMinecraftVersion()) + ")";
        }
    }

    public static final class Version {
        private final int major;
        private final int minor;
        private final int patch;

        public static Version fromString(String ver) {
            String[] split = ver.replace(']', ' ').replace('[', ' ').replaceAll(" ", "").split(",");
            return new Version(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }

        public static Version fromArray(int[] ver) {
            return new Version(ver[0], ver[1], ver[2]);
        }

        private Version(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.patch;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version other = (Version)o;
            if (this.getMajor() != other.getMajor()) {
                return false;
            }
            if (this.getMinor() != other.getMinor()) {
                return false;
            }
            return this.getPatch() == other.getPatch();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMajor();
            result = result * 59 + this.getMinor();
            result = result * 59 + this.getPatch();
            return result;
        }
    }

    public static class Dependency {
        private UUID uuid;
        private int[] version;

        public UUID getUuid() {
            return this.uuid;
        }

        public int[] getVersion() {
            return this.version;
        }

        public String toString() {
            return "ResourcePackManifest.Dependency(uuid=" + this.getUuid() + ", version=" + Arrays.toString(this.getVersion()) + ")";
        }
    }

    public static class Module {
        private String description;
        private String name;
        private UUID uuid;
        private int[] version;

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public int[] getVersion() {
            return this.version;
        }

        public String toString() {
            return "ResourcePackManifest.Module(description=" + this.getDescription() + ", name=" + this.getName() + ", uuid=" + this.getUuid() + ", version=" + Arrays.toString(this.getVersion()) + ")";
        }
    }
}

