/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.pack.ResourcePackManifest;
import org.geysermc.geyser.util.FileUtils;

public class ResourcePack {
    public static final Map<String, ResourcePack> PACKS = new HashMap<String, ResourcePack>();
    public static final int CHUNK_SIZE = 102400;
    private byte[] sha256;
    private File file;
    private ResourcePackManifest manifest;
    private ResourcePackManifest.Version version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPacks() {
        File directory = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("packs").toFile();
        if (!directory.exists()) {
            directory.mkdir();
            return;
        }
        for (File file : directory.listFiles()) {
            if (!file.getName().endsWith(".zip") && !file.getName().endsWith(".mcpack")) continue;
            ResourcePack pack = new ResourcePack();
            pack.sha256 = FileUtils.calculateSHA256(file);
            try (Stream<? extends ZipEntry> stream = null;){
                ZipFile zip = new ZipFile(file);
                stream = zip.stream();
                stream.forEach(x -> {
                    if (x.getName().contains("manifest.json")) {
                        try {
                            ResourcePackManifest manifest = FileUtils.loadJson(zip.getInputStream((ZipEntry)x), ResourcePackManifest.class);
                            if (manifest.getHeader().getUuid() != null) {
                                pack.file = file;
                                pack.manifest = manifest;
                                pack.version = ResourcePackManifest.Version.fromArray(manifest.getHeader().getVersion());
                                PACKS.put(pack.getManifest().getHeader().getUuid().toString(), pack);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    public byte[] getSha256() {
        return this.sha256;
    }

    public File getFile() {
        return this.file;
    }

    public ResourcePackManifest getManifest() {
        return this.manifest;
    }

    public ResourcePackManifest.Version getVersion() {
        return this.version;
    }
}

