/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.data.ExperimentData;
import com.nukkitx.protocol.bedrock.data.ResourcePackType;
import com.nukkitx.protocol.bedrock.packet.LoginPacket;
import com.nukkitx.protocol.bedrock.packet.ModalFormResponsePacket;
import com.nukkitx.protocol.bedrock.packet.MovePlayerPacket;
import com.nukkitx.protocol.bedrock.packet.PlayStatusPacket;
import com.nukkitx.protocol.bedrock.packet.ResourcePackChunkDataPacket;
import com.nukkitx.protocol.bedrock.packet.ResourcePackChunkRequestPacket;
import com.nukkitx.protocol.bedrock.packet.ResourcePackClientResponsePacket;
import com.nukkitx.protocol.bedrock.packet.ResourcePackDataInfoPacket;
import com.nukkitx.protocol.bedrock.packet.ResourcePackStackPacket;
import com.nukkitx.protocol.bedrock.packet.ResourcePacksInfoPacket;
import com.nukkitx.protocol.bedrock.packet.SetTitlePacket;
import java.io.FileInputStream;
import java.io.InputStream;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.network.LoggingPacketHandler;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.pack.ResourcePack;
import org.geysermc.geyser.pack.ResourcePackManifest;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.LoginEncryptionUtils;
import org.geysermc.geyser.util.MathUtils;

public class UpstreamPacketHandler
extends LoggingPacketHandler {
    public UpstreamPacketHandler(GeyserImpl geyser, GeyserSession session) {
        super(geyser, session);
    }

    private boolean translateAndDefault(BedrockPacket packet) {
        return Registries.BEDROCK_PACKET_TRANSLATORS.translate(packet.getClass(), packet, this.session);
    }

    @Override
    boolean defaultHandler(BedrockPacket packet) {
        return this.translateAndDefault(packet);
    }

    @Override
    public boolean handle(LoginPacket loginPacket) {
        if (this.geyser.isShuttingDown()) {
            this.session.disconnect(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.message", new Object[0]));
            return true;
        }
        BedrockPacketCodec packetCodec = MinecraftProtocol.getBedrockCodec(loginPacket.getProtocolVersion());
        if (packetCodec == null) {
            String supportedVersions = MinecraftProtocol.getAllSupportedBedrockVersions();
            if (loginPacket.getProtocolVersion() > MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()) {
                this.session.disconnect(GeyserLocale.getLocaleStringLog("geyser.network.outdated.server", supportedVersions));
                return true;
            }
            if (loginPacket.getProtocolVersion() < MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()) {
                this.session.disconnect(GeyserLocale.getLocaleStringLog("geyser.network.outdated.client", supportedVersions));
                return true;
            }
        }
        this.session.getUpstream().getSession().setPacketCodec(packetCodec);
        this.session.setBlockMappings(BlockRegistries.BLOCKS.forVersion(loginPacket.getProtocolVersion()));
        this.session.setItemMappings(Registries.ITEMS.forVersion(loginPacket.getProtocolVersion()));
        LoginEncryptionUtils.encryptPlayerConnection(this.session, loginPacket);
        if (this.session.isClosed()) {
            return true;
        }
        PlayStatusPacket playStatus = new PlayStatusPacket();
        playStatus.setStatus(PlayStatusPacket.Status.LOGIN_SUCCESS);
        this.session.sendUpstreamPacket(playStatus);
        this.geyser.getSessionManager().addPendingSession(this.session);
        ResourcePacksInfoPacket resourcePacksInfo = new ResourcePacksInfoPacket();
        for (ResourcePack resourcePack : ResourcePack.PACKS.values()) {
            ResourcePackManifest.Header header = resourcePack.getManifest().getHeader();
            resourcePacksInfo.getResourcePackInfos().add(new ResourcePacksInfoPacket.Entry(header.getUuid().toString(), header.getVersionString(), resourcePack.getFile().length(), "", "", "", false, false));
        }
        resourcePacksInfo.setForcedToAccept(GeyserImpl.getInstance().getConfig().isForceResourcePacks());
        this.session.sendUpstreamPacket(resourcePacksInfo);
        GeyserLocale.loadGeyserLocale(this.session.getLocale());
        return true;
    }

    @Override
    public boolean handle(ResourcePackClientResponsePacket packet) {
        switch (packet.getStatus()) {
            case COMPLETED: {
                if (this.geyser.getConfig().getRemote().getAuthType() != AuthType.ONLINE) {
                    this.session.authenticate(this.session.getAuthData().name());
                } else if (!this.couldLoginUserByName(this.session.getAuthData().name())) {
                    this.session.connect();
                }
                this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.connect", this.session.getAuthData().name()));
                break;
            }
            case SEND_PACKS: {
                for (String id : packet.getPackIds()) {
                    ResourcePackDataInfoPacket data = new ResourcePackDataInfoPacket();
                    String[] packID = id.split("_");
                    ResourcePack pack = ResourcePack.PACKS.get(packID[0]);
                    ResourcePackManifest.Header header = pack.getManifest().getHeader();
                    data.setPackId(header.getUuid());
                    int chunkCount = (int)Math.ceil((double)((int)pack.getFile().length()) / 102400.0);
                    data.setChunkCount(chunkCount);
                    data.setCompressedPackSize(pack.getFile().length());
                    data.setMaxChunkSize(102400L);
                    data.setHash(pack.getSha256());
                    data.setPackVersion(packID[1]);
                    data.setPremium(false);
                    data.setType(ResourcePackType.RESOURCE);
                    this.session.sendUpstreamPacket(data);
                }
                break;
            }
            case HAVE_ALL_PACKS: {
                ResourcePackStackPacket stackPacket = new ResourcePackStackPacket();
                stackPacket.setExperimentsPreviouslyToggled(false);
                stackPacket.setForcedToAccept(false);
                stackPacket.setGameVersion(this.session.getClientData().getGameVersion());
                for (ResourcePack pack : ResourcePack.PACKS.values()) {
                    ResourcePackManifest.Header header = pack.getManifest().getHeader();
                    stackPacket.getResourcePacks().add(new ResourcePackStackPacket.Entry(header.getUuid().toString(), header.getVersionString(), ""));
                }
                if (this.session.getItemMappings().getFurnaceMinecartData() != null) {
                    stackPacket.getExperiments().add(new ExperimentData("data_driven_items", true));
                }
                this.session.sendUpstreamPacket(stackPacket);
                break;
            }
            default: {
                this.session.disconnect("disconnectionScreen.resourcePack");
            }
        }
        return true;
    }

    @Override
    public boolean handle(ModalFormResponsePacket packet) {
        this.session.executeInEventLoop(() -> this.session.getFormCache().handleResponse(packet));
        return true;
    }

    private boolean couldLoginUserByName(String bedrockUsername) {
        GeyserConfiguration.IUserAuthenticationInfo info;
        String refreshToken;
        if (this.geyser.getConfig().getSavedUserLogins().contains(bedrockUsername) && (refreshToken = this.geyser.refreshTokenFor(bedrockUsername)) != null) {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.auth.stored_credentials", this.session.getAuthData().name()));
            this.session.authenticateWithRefreshToken(refreshToken);
            return true;
        }
        if (this.geyser.getConfig().getUserAuths() != null && (info = this.geyser.getConfig().getUserAuths().get(bedrockUsername)) != null) {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.auth.stored_credentials", this.session.getAuthData().name()));
            this.session.setMicrosoftAccount(info.isMicrosoftAccount());
            this.session.authenticate(info.getEmail(), info.getPassword());
            return true;
        }
        PendingMicrosoftAuthentication.AuthenticationTask task = this.geyser.getPendingMicrosoftAuthentication().getTask(this.session.getAuthData().xuid());
        return task != null && task.getAuthentication().isDone() && this.session.onMicrosoftLoginComplete(task);
    }

    @Override
    public boolean handle(MovePlayerPacket packet) {
        if (this.session.isLoggingIn()) {
            SetTitlePacket titlePacket = new SetTitlePacket();
            titlePacket.setType(SetTitlePacket.Type.ACTIONBAR);
            titlePacket.setText(GeyserLocale.getPlayerLocaleString("geyser.auth.login.wait", this.session.getLocale(), new Object[0]));
            titlePacket.setFadeInTime(0);
            titlePacket.setFadeOutTime(1);
            titlePacket.setStayTime(2);
            titlePacket.setXuid("");
            titlePacket.setPlatformOnlineId("");
            this.session.sendUpstreamPacket(titlePacket);
        }
        return this.translateAndDefault(packet);
    }

    @Override
    public boolean handle(ResourcePackChunkRequestPacket packet) {
        ResourcePackChunkDataPacket data = new ResourcePackChunkDataPacket();
        ResourcePack pack = ResourcePack.PACKS.get(packet.getPackId().toString());
        data.setChunkIndex(packet.getChunkIndex());
        data.setProgress(packet.getChunkIndex() * 102400);
        data.setPackVersion(packet.getPackVersion());
        data.setPackId(packet.getPackId());
        int offset = packet.getChunkIndex() * 102400;
        byte[] packData = new byte[(int)MathUtils.constrain(pack.getFile().length() - (long)offset, 0.0, 102400.0)];
        try (FileInputStream inputStream = new FileInputStream(pack.getFile());){
            ((InputStream)inputStream).skip(offset);
            ((InputStream)inputStream).read(packData, 0, packData.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data.setData(packData);
        this.session.sendUpstreamPacket(data);
        return true;
    }
}

