/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class QueryPacketHandler {
    public static final byte HANDSHAKE = 9;
    public static final byte STATISTICS = 0;
    private final GeyserImpl geyser;
    private final InetSocketAddress sender;
    private final byte type;
    private final int sessionId;
    private byte[] token;

    public QueryPacketHandler(GeyserImpl geyser, InetSocketAddress sender, ByteBuf buffer) {
        this.geyser = geyser;
        this.sender = sender;
        this.type = buffer.readByte();
        this.sessionId = buffer.readInt();
        this.regenerateToken();
        this.handle();
    }

    public static boolean isQueryPacket(ByteBuf buffer) {
        return buffer.readableBytes() >= 7 && buffer.readUnsignedShort() == 65277;
    }

    private void handle() {
        switch (this.type) {
            case 9: {
                this.sendToken();
                break;
            }
            case 0: {
                this.sendQueryData();
            }
        }
    }

    private void sendToken() {
        ByteBuf reply = ByteBufAllocator.DEFAULT.ioBuffer(10);
        reply.writeByte(9);
        reply.writeInt(this.sessionId);
        reply.writeBytes(QueryPacketHandler.getTokenString(this.token, this.sender.getAddress()));
        reply.writeByte(0);
        this.sendPacket(reply);
    }

    private void sendQueryData() {
        byte[] gameData = this.getGameData();
        byte[] playerData = this.getPlayers();
        ByteBuf reply = ByteBufAllocator.DEFAULT.ioBuffer(5 + gameData.length + playerData.length);
        reply.writeByte(0);
        reply.writeInt(this.sessionId);
        reply.writeBytes(gameData);
        reply.writeBytes(playerData);
        this.sendPacket(reply);
    }

    private byte[] getGameData() {
        String maxPlayerCount;
        String currentPlayerCount;
        String motd;
        ByteArrayOutputStream query = new ByteArrayOutputStream();
        GeyserPingInfo pingInfo = null;
        if (this.geyser.getConfig().isPassthroughMotd() || this.geyser.getConfig().isPassthroughPlayerCounts()) {
            pingInfo = this.geyser.getBootstrap().getGeyserPingPassthrough().getPingInformation();
        }
        if (this.geyser.getConfig().isPassthroughMotd() && pingInfo != null) {
            String[] javaMotd = MessageTranslator.convertMessageLenient(pingInfo.getDescription()).split("\n");
            motd = javaMotd[0].trim();
        } else {
            motd = this.geyser.getConfig().getBedrock().getMotd1();
        }
        if (this.geyser.getConfig().isPassthroughPlayerCounts() && pingInfo != null) {
            currentPlayerCount = String.valueOf(pingInfo.getPlayers().getOnline());
            maxPlayerCount = String.valueOf(pingInfo.getPlayers().getMax());
        } else {
            currentPlayerCount = String.valueOf(this.geyser.getSessionManager().getSessions().size());
            maxPlayerCount = String.valueOf(this.geyser.getConfig().getMaxPlayers());
        }
        String map = this.geyser.getConfig().isPassthroughProtocolName() && pingInfo != null ? pingInfo.getVersion().getName() : "Geyser";
        HashMap<String, Object> gameData = new HashMap<String, Object>();
        gameData.put("hostname", motd);
        gameData.put("gametype", "SMP");
        gameData.put("game_id", "MINECRAFT");
        gameData.put("version", "Geyser (git-eab92da98884308b6e4b4a5deb1de97b2fbd3c6e-eab92da) " + MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getMinecraftVersion());
        gameData.put("plugins", "");
        gameData.put("map", map);
        gameData.put("numplayers", currentPlayerCount);
        gameData.put("maxplayers", maxPlayerCount);
        gameData.put("hostport", String.valueOf(this.geyser.getConfig().getBedrock().getPort()));
        gameData.put("hostip", this.geyser.getConfig().getBedrock().getAddress());
        try {
            this.writeString(query, "GeyserMC");
            query.write(-128);
            query.write(0);
            for (Map.Entry entry : gameData.entrySet()) {
                this.writeString(query, (String)entry.getKey());
                this.writeString(query, (String)entry.getValue());
            }
            query.write(new byte[]{0, 1});
            return query.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private byte[] getPlayers() {
        ByteArrayOutputStream query = new ByteArrayOutputStream();
        GeyserPingInfo pingInfo = null;
        if (this.geyser.getConfig().isPassthroughMotd() || this.geyser.getConfig().isPassthroughPlayerCounts()) {
            pingInfo = this.geyser.getBootstrap().getGeyserPingPassthrough().getPingInformation();
        }
        try {
            this.writeString(query, "player_");
            query.write(0);
            if (pingInfo != null) {
                for (String username : pingInfo.getPlayerList()) {
                    this.writeString(query, username);
                }
            }
            query.write(0);
            return query.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private void writeString(OutputStream stream, String value) throws IOException {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            stream.write((byte)value.charAt(i));
        }
        stream.write(0);
    }

    private void sendPacket(ByteBuf data) {
        this.geyser.getBedrockServer().getRakNet().send(this.sender, data);
    }

    public void regenerateToken() {
        byte[] token = new byte[16];
        for (int i = 0; i < 16; ++i) {
            token[i] = (byte)ThreadLocalRandom.current().nextInt(255);
        }
        this.token = token;
    }

    public static byte[] getTokenString(byte[] token, InetAddress address) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(address.toString().getBytes(StandardCharsets.UTF_8));
            digest.update(token);
            byte[] digestBytes = Arrays.copyOf(digest.digest(), 4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(digestBytes);
            return (byteBuffer.getInt() + "\u0000").getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            return (ByteBuffer.allocate(4).putInt(ThreadLocalRandom.current().nextInt()).getInt() + "\u0000").getBytes();
        }
    }
}

