/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.physics;

import com.nukkitx.math.GenericMath;
import com.nukkitx.math.vector.Vector3d;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.MovePlayerPacket;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.block.BlockPositionIterator;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.ScaffoldingCollision;
import org.geysermc.geyser.util.BlockUtils;

public class CollisionManager {
    private final GeyserSession session;
    private final BoundingBox playerBoundingBox;
    private boolean touchingScaffolding;
    private boolean onScaffolding;
    public static final double COLLISION_TOLERANCE = 1.0E-5;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#####", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final double PLAYER_STEP_UP = 0.6;
    private static final double INCORRECT_MOVEMENT_THRESHOLD = 0.08;

    public CollisionManager(GeyserSession session) {
        this.session = session;
        this.playerBoundingBox = new BoundingBox(0.0, 0.0, 0.0, 0.6, 1.8, 0.6);
    }

    public void updatePlayerBoundingBox(Vector3f position) {
        this.updatePlayerBoundingBox(position.toDouble());
    }

    public void updatePlayerBoundingBox(Vector3d position) {
        this.updatePlayerBoundingBox();
        this.playerBoundingBox.setMiddleX(position.getX());
        this.playerBoundingBox.setMiddleY(position.getY() + this.playerBoundingBox.getSizeY() / 2.0);
        this.playerBoundingBox.setMiddleZ(position.getZ());
    }

    public void updatePlayerBoundingBox() {
        double playerHeight = this.session.getPlayerEntity().getBoundingBoxHeight();
        this.playerBoundingBox.setMiddleY(this.playerBoundingBox.getMiddleY() - this.playerBoundingBox.getSizeY() / 2.0 + playerHeight / 2.0);
        this.playerBoundingBox.setSizeY(playerHeight);
    }

    public Vector3d adjustBedrockPosition(Vector3f bedrockPosition, boolean onGround, boolean teleported) {
        boolean newOnGround;
        PistonCache pistonCache = this.session.getPistonCache();
        if (pistonCache.isPlayerAttachedToHoney()) {
            return null;
        }
        double javaY = bedrockPosition.getY() - EntityDefinitions.PLAYER.offset();
        Vector3d position = Vector3d.from(Double.parseDouble(Float.toString(bedrockPosition.getX())), javaY, Double.parseDouble(Float.toString(bedrockPosition.getZ())));
        Vector3d startingPos = this.playerBoundingBox.getBottomCenter();
        Vector3d movement = position.sub(startingPos);
        Vector3d adjustedMovement = this.correctPlayerMovement(movement, false, teleported);
        this.playerBoundingBox.translate(adjustedMovement.getX(), adjustedMovement.getY(), adjustedMovement.getZ());
        this.playerBoundingBox.translate(pistonCache.getPlayerMotion().getX(), pistonCache.getPlayerMotion().getY(), pistonCache.getPlayerMotion().getZ());
        if (!this.correctPlayerPosition()) {
            this.recalculatePosition();
            return null;
        }
        if (pistonCache.isPlayerCollided()) {
            return null;
        }
        position = this.playerBoundingBox.getBottomCenter();
        boolean bl = newOnGround = adjustedMovement.getY() != movement.getY() && movement.getY() < 0.0 || onGround;
        if (onGround != newOnGround || movement.distanceSquared(adjustedMovement) > 0.08) {
            SessionPlayerEntity playerEntity = this.session.getPlayerEntity();
            if (pistonCache.getPlayerMotion().equals(Vector3f.ZERO) && !pistonCache.isPlayerSlimeCollision()) {
                playerEntity.moveAbsolute(position.toFloat(), playerEntity.getYaw(), playerEntity.getPitch(), playerEntity.getHeadYaw(), newOnGround, true);
            }
        }
        if (!onGround) {
            position = Vector3d.from(position.getX(), Double.parseDouble(DECIMAL_FORMAT.format(position.getY())), position.getZ());
        }
        return position;
    }

    public void recalculatePosition() {
        SessionPlayerEntity entity = this.session.getPlayerEntity();
        ((Entity)entity).updateBedrockMetadata();
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(entity.getGeyserId());
        movePlayerPacket.setPosition(entity.getPosition());
        movePlayerPacket.setRotation(entity.getBedrockRotation());
        movePlayerPacket.setMode(MovePlayerPacket.Mode.NORMAL);
        this.session.sendUpstreamPacket(movePlayerPacket);
    }

    public BlockPositionIterator collidableBlocksIterator(BoundingBox box) {
        Vector3d position = Vector3d.from(box.getMiddleX(), box.getMiddleY() - box.getSizeY() / 2.0, box.getMiddleZ());
        double pistonExpand = this.session.getPistonCache().getPistons().isEmpty() ? 0.0 : 1.0;
        int minCollisionX = (int)Math.floor(position.getX() - (box.getSizeX() / 2.0 + 1.0E-5 + pistonExpand));
        int maxCollisionX = (int)Math.floor(position.getX() + box.getSizeX() / 2.0 + 1.0E-5 + pistonExpand);
        int minCollisionY = (int)Math.floor(position.getY() - 0.5 - 1.0E-5 - pistonExpand / 2.0);
        int maxCollisionY = (int)Math.floor(position.getY() + box.getSizeY() + pistonExpand);
        int minCollisionZ = (int)Math.floor(position.getZ() - (box.getSizeZ() / 2.0 + 1.0E-5 + pistonExpand));
        int maxCollisionZ = (int)Math.floor(position.getZ() + box.getSizeZ() / 2.0 + 1.0E-5 + pistonExpand);
        return new BlockPositionIterator(minCollisionX, minCollisionY, minCollisionZ, maxCollisionX, maxCollisionY, maxCollisionZ);
    }

    public BlockPositionIterator playerCollidableBlocksIterator() {
        return this.collidableBlocksIterator(this.playerBoundingBox);
    }

    public boolean correctPlayerPosition() {
        BlockCollision blockCollision;
        this.touchingScaffolding = false;
        this.onScaffolding = false;
        BlockPositionIterator iter = this.session.getCollisionManager().playerCollidableBlocksIterator();
        while (iter.hasNext()) {
            blockCollision = BlockUtils.getCollisionAt(this.session, iter.getX(), iter.getY(), iter.getZ());
            if (blockCollision != null) {
                blockCollision.beforeCorrectPosition(iter.getX(), iter.getY(), iter.getZ(), this.playerBoundingBox);
            }
            iter.next();
        }
        iter.reset();
        while (iter.hasNext()) {
            blockCollision = BlockUtils.getCollisionAt(this.session, iter.getX(), iter.getY(), iter.getZ());
            if (blockCollision != null && !blockCollision.correctPosition(this.session, iter.getX(), iter.getY(), iter.getZ(), this.playerBoundingBox)) {
                return false;
            }
            iter.next();
        }
        this.updateScaffoldingFlags(true);
        return true;
    }

    public Vector3d correctPlayerMovement(Vector3d movement, boolean checkWorld, boolean teleported) {
        if (teleported || !checkWorld && this.session.getPistonCache().getPistons().isEmpty()) {
            return movement;
        }
        return this.correctMovement(movement, this.playerBoundingBox, this.session.getPlayerEntity().isOnGround(), 0.6, checkWorld);
    }

    public Vector3d correctMovement(Vector3d movement, BoundingBox boundingBox, boolean onGround, double stepUp, boolean checkWorld) {
        Vector3d adjustedMovement = movement;
        if (!movement.equals(Vector3d.ZERO)) {
            adjustedMovement = this.correctMovementForCollisions(movement, boundingBox, checkWorld);
        }
        boolean verticalCollision = adjustedMovement.getY() != movement.getY();
        boolean horizontalCollision = adjustedMovement.getX() != movement.getX() || adjustedMovement.getZ() != movement.getZ();
        boolean falling = movement.getY() < 0.0;
        boolean bl = onGround = onGround || verticalCollision && falling;
        if (onGround && horizontalCollision) {
            Vector3d horizontalMovement = Vector3d.from(movement.getX(), 0.0, movement.getZ());
            Vector3d stepUpMovement = this.correctMovementForCollisions(horizontalMovement.up(stepUp), boundingBox, checkWorld);
            BoundingBox stretchedBoundingBox = boundingBox.clone();
            stretchedBoundingBox.extend(horizontalMovement);
            double maxStepUp = this.correctMovementForCollisions(Vector3d.from(0.0, stepUp, 0.0), stretchedBoundingBox, checkWorld).getY();
            if (maxStepUp < stepUp) {
                boundingBox.translate(0.0, maxStepUp, 0.0);
                Vector3d adjustedStepUpMovement = this.correctMovementForCollisions(horizontalMovement, boundingBox, checkWorld);
                boundingBox.translate(0.0, -maxStepUp, 0.0);
                if (this.squaredHorizontalLength(adjustedStepUpMovement) > this.squaredHorizontalLength(stepUpMovement)) {
                    stepUpMovement = adjustedStepUpMovement.up(maxStepUp);
                }
            }
            if (this.squaredHorizontalLength(stepUpMovement) > this.squaredHorizontalLength(adjustedMovement)) {
                boundingBox.translate(stepUpMovement.getX(), stepUpMovement.getY(), stepUpMovement.getZ());
                double verticalMovement = this.correctMovementForCollisions(Vector3d.from(0.0, movement.getY() - stepUpMovement.getY(), 0.0), boundingBox, checkWorld).getY();
                boundingBox.translate(-stepUpMovement.getX(), -stepUpMovement.getY(), -stepUpMovement.getZ());
                adjustedMovement = stepUpMovement = stepUpMovement.up(verticalMovement);
            }
        }
        return adjustedMovement;
    }

    private double squaredHorizontalLength(Vector3d vector) {
        return vector.getX() * vector.getX() + vector.getZ() * vector.getZ();
    }

    private Vector3d correctMovementForCollisions(Vector3d movement, BoundingBox boundingBox, boolean checkWorld) {
        boolean checkZFirst;
        double movementX = movement.getX();
        double movementY = movement.getY();
        double movementZ = movement.getZ();
        BoundingBox movementBoundingBox = boundingBox.clone();
        movementBoundingBox.extend(movement);
        BlockPositionIterator iter = this.collidableBlocksIterator(movementBoundingBox);
        if (Math.abs(movementY) > 1.0E-5) {
            movementY = this.computeCollisionOffset(boundingBox, Axis.Y, movementY, iter, checkWorld);
            boundingBox.translate(0.0, movementY, 0.0);
        }
        boolean bl = checkZFirst = Math.abs(movementZ) > Math.abs(movementX);
        if (checkZFirst && Math.abs(movementZ) > 1.0E-5) {
            movementZ = this.computeCollisionOffset(boundingBox, Axis.Z, movementZ, iter, checkWorld);
            boundingBox.translate(0.0, 0.0, movementZ);
        }
        if (Math.abs(movementX) > 1.0E-5) {
            movementX = this.computeCollisionOffset(boundingBox, Axis.X, movementX, iter, checkWorld);
            boundingBox.translate(movementX, 0.0, 0.0);
        }
        if (!checkZFirst && Math.abs(movementZ) > 1.0E-5) {
            movementZ = this.computeCollisionOffset(boundingBox, Axis.Z, movementZ, iter, checkWorld);
            boundingBox.translate(0.0, 0.0, movementZ);
        }
        boundingBox.translate(-movementX, -movementY, -movementZ);
        return Vector3d.from(movementX, movementY, movementZ);
    }

    private double computeCollisionOffset(BoundingBox boundingBox, Axis axis, double offset, BlockPositionIterator iter, boolean checkWorld) {
        iter.reset();
        while (iter.hasNext()) {
            BlockCollision blockCollision;
            int x = iter.getX();
            int y = iter.getY();
            int z = iter.getZ();
            if (checkWorld && (blockCollision = BlockUtils.getCollisionAt(this.session, x, y, z)) != null && !(blockCollision instanceof ScaffoldingCollision)) {
                offset = blockCollision.computeCollisionOffset(x, y, z, boundingBox, axis, offset);
            }
            if (Math.abs(offset = this.session.getPistonCache().computeCollisionOffset(Vector3i.from(x, y, z), boundingBox, axis, offset)) < 1.0E-5) {
                return 0.0;
            }
            iter.next();
        }
        return offset;
    }

    public boolean mustPlayerSneakHere() {
        return this.checkPose(EntityDefinitions.PLAYER.height());
    }

    public boolean mustPlayerCrawlHere() {
        return this.checkPose(1.5f);
    }

    private boolean checkPose(float height) {
        Vector3i position = this.session.getPlayerEntity().getPosition().toInt();
        BlockCollision collision = BlockUtils.getCollisionAt(this.session, position);
        if (collision != null) {
            double originalY = this.playerBoundingBox.getMiddleY();
            double originalHeight = this.playerBoundingBox.getSizeY();
            double standingY = originalY - originalHeight / 2.0 + (double)height / 2.0;
            this.playerBoundingBox.setSizeY(EntityDefinitions.PLAYER.height());
            this.playerBoundingBox.setMiddleY(standingY);
            boolean result = collision.checkIntersection(position, this.playerBoundingBox);
            this.playerBoundingBox.setSizeY(originalHeight);
            this.playerBoundingBox.setMiddleY(originalY);
            return result |= this.session.getPistonCache().checkCollision(position, this.playerBoundingBox);
        }
        return false;
    }

    public boolean isPlayerInWater() {
        return this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.session.getPlayerEntity().getPosition().toInt()) == BlockStateValues.JAVA_WATER_ID;
    }

    public boolean isWaterInEyes() {
        double eyeX = this.playerBoundingBox.getMiddleX();
        double eyeY = this.playerBoundingBox.getMiddleY() - this.playerBoundingBox.getSizeY() / 2.0 + (double)this.session.getEyeHeight();
        double eyeZ = this.playerBoundingBox.getMiddleZ();
        int blockID = this.session.getGeyser().getWorldManager().getBlockAt(this.session, GenericMath.floor(eyeX), GenericMath.floor(eyeY -= 0.1111111111111111), GenericMath.floor(eyeZ));
        double waterHeight = BlockStateValues.getWaterHeight(blockID);
        return waterHeight != -1.0 && eyeY < Math.floor(eyeY) + waterHeight;
    }

    public void updateScaffoldingFlags(boolean updateMetadata) {
        SessionPlayerEntity entity = this.session.getPlayerEntity();
        boolean isSneakingWithScaffolding = (this.touchingScaffolding || this.onScaffolding) && this.session.isSneaking();
        entity.setFlag(EntityFlag.OVER_DESCENDABLE_BLOCK, this.onScaffolding);
        entity.setFlag(EntityFlag.IN_ASCENDABLE_BLOCK, this.touchingScaffolding);
        entity.setFlag(EntityFlag.OVER_SCAFFOLDING, isSneakingWithScaffolding);
        entity.setFlag(EntityFlag.IN_SCAFFOLDING, this.touchingScaffolding);
        if (updateMetadata) {
            this.session.getPlayerEntity().updateBedrockMetadata();
        }
    }

    public BoundingBox getPlayerBoundingBox() {
        return this.playerBoundingBox;
    }

    public void setTouchingScaffolding(boolean touchingScaffolding) {
        this.touchingScaffolding = touchingScaffolding;
    }

    public void setOnScaffolding(boolean onScaffolding) {
        this.onScaffolding = onScaffolding;
    }
}

