/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.click;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.inventory.ContainerActionType;
import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.mc.protocol.data.game.inventory.MoveToHotbarAction;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClickPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.CraftingInventoryTranslator;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.jetbrains.annotations.Contract;

public final class ClickPlan {
    private final List<ClickAction> plan = new ArrayList<ClickAction>();
    private final Int2ObjectMap<GeyserItemStack> simulatedItems;
    private Int2ObjectMap<ItemStack> changedItems;
    private GeyserItemStack simulatedCursor;
    private boolean finished;
    private final GeyserSession session;
    private final InventoryTranslator translator;
    private final Inventory inventory;
    private final int gridSize;

    public ClickPlan(GeyserSession session, InventoryTranslator translator, Inventory inventory) {
        this.session = session;
        this.translator = translator;
        this.inventory = inventory;
        this.simulatedItems = new Int2ObjectOpenHashMap(inventory.getSize());
        this.changedItems = null;
        this.simulatedCursor = session.getPlayerInventory().getCursor().copy();
        this.finished = false;
        this.gridSize = translator.getGridSize();
    }

    private void resetSimulation() {
        this.simulatedItems.clear();
        this.simulatedCursor = this.session.getPlayerInventory().getCursor().copy();
    }

    public void add(Click click, int slot) {
        this.add(click, slot, false);
    }

    public void add(Click click, int slot, boolean force) {
        if (this.finished) {
            throw new UnsupportedOperationException("ClickPlan already executed");
        }
        if (click == Click.LEFT_OUTSIDE || click == Click.RIGHT_OUTSIDE) {
            slot = -999;
        }
        ClickAction action = new ClickAction(click, slot, force);
        this.plan.add(action);
        this.simulateAction(action);
    }

    public void execute(boolean refresh) {
        this.resetSimulation();
        ListIterator<ClickAction> planIter = this.plan.listIterator();
        while (planIter.hasNext()) {
            int stateId;
            ClickAction action = planIter.next();
            if (action.slot != -999 && this.translator.getSlotType(action.slot) != SlotType.NORMAL) {
                refresh = true;
            }
            this.changedItems = new Int2ObjectOpenHashMap();
            boolean emulatePost1_16Logic = this.session.isEmulatePost1_16Logic();
            if (emulatePost1_16Logic) {
                stateId = this.stateIdHack(action);
                this.simulateAction(action);
            } else {
                stateId = this.inventory.getStateId();
            }
            Object clickedItemStack = !planIter.hasNext() && refresh ? InventoryUtils.REFRESH_ITEM : (emulatePost1_16Logic ? this.simulatedCursor.getItemStack() : (action.click.actionType == ContainerActionType.DROP_ITEM || action.slot == -999 ? null : this.getItem(action.slot).getItemStack()));
            if (!emulatePost1_16Logic) {
                this.simulateAction(action);
            }
            ServerboundContainerClickPacket clickPacket = new ServerboundContainerClickPacket(this.inventory.getId(), stateId, action.slot, action.click.actionType, action.click.action, (ItemStack)clickedItemStack, this.changedItems);
            this.session.sendDownstreamPacket(clickPacket);
        }
        this.session.getPlayerInventory().setCursor(this.simulatedCursor, this.session);
        for (Int2ObjectMap.Entry simulatedSlot : this.simulatedItems.int2ObjectEntrySet()) {
            this.inventory.setItem(simulatedSlot.getIntKey(), (GeyserItemStack)simulatedSlot.getValue(), this.session);
        }
        this.finished = true;
    }

    public GeyserItemStack getItem(int slot) {
        return (GeyserItemStack)this.simulatedItems.computeIfAbsent(slot, k -> this.inventory.getItem(slot).copy());
    }

    public GeyserItemStack getCursor() {
        return this.simulatedCursor;
    }

    private void setItem(int slot, GeyserItemStack item) {
        this.simulatedItems.put(slot, (Object)item);
        this.onSlotItemChange(slot, item);
    }

    private void setCursor(GeyserItemStack item) {
        this.simulatedCursor = item;
    }

    private void add(int slot, GeyserItemStack itemStack, int amount) {
        itemStack.add(amount);
        this.onSlotItemChange(slot, itemStack);
    }

    private void sub(int slot, GeyserItemStack itemStack, int amount) {
        itemStack.sub(amount);
        this.onSlotItemChange(slot, itemStack);
    }

    private void setAmount(int slot, GeyserItemStack itemStack, int amount) {
        itemStack.setAmount(amount);
        this.onSlotItemChange(slot, itemStack);
    }

    private void onSlotItemChange(int slot, GeyserItemStack itemStack) {
        if (this.changedItems != null) {
            this.changedItems.put(slot, (Object)itemStack.getItemStack());
        }
    }

    private void simulateAction(ClickAction action) {
        GeyserItemStack cursor = this.getCursor();
        switch (action.click) {
            case LEFT_OUTSIDE: {
                this.setCursor(GeyserItemStack.EMPTY);
                return;
            }
            case RIGHT_OUTSIDE: {
                if (!cursor.isEmpty()) {
                    cursor.sub(1);
                }
                return;
            }
        }
        GeyserItemStack clicked = this.getItem(action.slot);
        if (this.translator.getSlotType(action.slot) == SlotType.OUTPUT) {
            switch (action.click) {
                case LEFT: 
                case RIGHT: {
                    if (cursor.isEmpty() && !clicked.isEmpty()) {
                        this.setCursor(clicked.copy());
                    } else if (InventoryUtils.canStack(cursor, clicked)) {
                        cursor.add(clicked.getAmount());
                    }
                    this.reduceCraftingGrid(false);
                    this.setItem(action.slot, GeyserItemStack.EMPTY);
                    break;
                }
                case LEFT_SHIFT: {
                    this.reduceCraftingGrid(true);
                }
            }
        } else {
            switch (action.click) {
                case LEFT: {
                    if (!InventoryUtils.canStack(cursor, clicked)) {
                        this.setCursor(clicked);
                        this.setItem(action.slot, cursor);
                        break;
                    }
                    this.setCursor(GeyserItemStack.EMPTY);
                    this.add(action.slot, clicked, cursor.getAmount());
                    break;
                }
                case RIGHT: {
                    if (cursor.isEmpty() && !clicked.isEmpty()) {
                        int half = clicked.getAmount() / 2;
                        this.setCursor(clicked.copy(clicked.getAmount() - half));
                        this.setAmount(action.slot, clicked, half);
                        break;
                    }
                    if (!cursor.isEmpty() && clicked.isEmpty()) {
                        cursor.sub(1);
                        this.setItem(action.slot, cursor.copy(1));
                        break;
                    }
                    if (!InventoryUtils.canStack(cursor, clicked)) break;
                    cursor.sub(1);
                    this.add(action.slot, clicked, 1);
                    break;
                }
                case SWAP_TO_HOTBAR_1: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(0), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_2: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(1), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_3: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(2), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_4: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(3), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_5: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(4), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_6: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(5), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_7: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(6), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_8: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(7), clicked);
                    break;
                }
                case SWAP_TO_HOTBAR_9: {
                    this.swap(action.slot, this.inventory.getOffsetForHotbar(8), clicked);
                    break;
                }
                case LEFT_SHIFT: {
                    break;
                }
                case DROP_ONE: {
                    if (clicked.isEmpty()) break;
                    this.sub(action.slot, clicked, 1);
                    break;
                }
                case DROP_ALL: {
                    this.setItem(action.slot, GeyserItemStack.EMPTY);
                }
            }
        }
    }

    private void swap(int sourceSlot, int destSlot, GeyserItemStack sourceItem) {
        GeyserItemStack destinationItem = this.getItem(destSlot);
        this.setItem(sourceSlot, destinationItem);
        this.setItem(destSlot, sourceItem);
    }

    private int stateIdHack(ClickAction action) {
        int stateId = this.inventory.getNextStateId() != -1 ? this.inventory.getNextStateId() : this.inventory.getStateId();
        if (this.inventory.getContainerType() == ContainerType.CRAFTING && CraftingInventoryTranslator.isCraftingGrid(action.slot)) {
            int stateIdIncrements;
            GeyserItemStack clicked = this.getItem(action.slot);
            if (action.click == Click.LEFT) {
                stateIdIncrements = !clicked.isEmpty() && !InventoryUtils.canStack(this.simulatedCursor, clicked) ? 2 : 1;
            } else if (action.click == Click.RIGHT) {
                stateIdIncrements = 1;
            } else if (action.click.actionType == ContainerActionType.MOVE_TO_HOTBAR_SLOT) {
                stateIdIncrements = 1;
            } else {
                if (this.session.getGeyser().getConfig().isDebugMode()) {
                    this.session.getGeyser().getLogger().debug("Not sure how to handle state ID hack in crafting table: " + this.plan);
                }
                stateIdIncrements = 1;
            }
            this.inventory.incrementStateId(stateIdIncrements);
        }
        return stateId;
    }

    private void reduceCraftingGrid(boolean makeAll) {
        int i;
        int crafted;
        if (this.gridSize == -1) {
            return;
        }
        if (!makeAll) {
            crafted = 1;
        } else {
            crafted = 0;
            for (i = 0; i < this.gridSize; ++i) {
                GeyserItemStack item = this.getItem(i + 1);
                if (item.isEmpty()) continue;
                if (crafted == 0) {
                    crafted = item.getAmount();
                }
                crafted = Math.min(crafted, item.getAmount());
            }
        }
        for (i = 0; i < this.gridSize; ++i) {
            int slot = i + 1;
            GeyserItemStack item = this.getItem(slot);
            if (item.isEmpty()) continue;
            this.sub(slot, item, crafted);
        }
    }

    @Contract(value="-> new")
    public IntSet getAffectedSlots() {
        IntOpenHashSet affectedSlots = new IntOpenHashSet();
        for (ClickAction action : this.plan) {
            if (this.translator.getSlotType(action.slot) == SlotType.OUTPUT || action.slot == -999) continue;
            affectedSlots.add(action.slot);
            if (action.click.actionType != ContainerActionType.MOVE_TO_HOTBAR_SLOT) continue;
            affectedSlots.add(this.inventory.getOffsetForHotbar(((MoveToHotbarAction)action.click.action).ordinal()));
        }
        return affectedSlots;
    }

    private record ClickAction(Click click, int slot, boolean force) {
    }
}

