/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.VillagerData;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.merchant.VillagerEntity;
import org.geysermc.geyser.entity.type.living.monster.ZombieEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class ZombieVillagerEntity
extends ZombieEntity {
    public ZombieVillagerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setTransforming(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.IS_TRANSFORMING, entityMetadata.getPrimitiveValue());
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    public void setZombieVillagerData(EntityMetadata<VillagerData, ?> entityMetadata) {
        VillagerData villagerData = entityMetadata.getValue();
        this.dirtyMetadata.put(EntityData.VARIANT, VillagerEntity.getBedrockProfession(villagerData.getProfession()));
        this.dirtyMetadata.put(EntityData.MARK_VARIANT, VillagerEntity.getBedrockRegion(villagerData.getType()));
        this.dirtyMetadata.put(EntityData.TRADE_TIER, villagerData.getLevel() - 1);
    }

    @Override
    protected boolean isShaking() {
        return this.getFlag(EntityFlag.IS_TRANSFORMING) || super.isShaking();
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (itemInHand.getJavaId() == this.session.getItemMappings().getStoredItems().goldenApple()) {
            return InteractiveTag.CURE;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (itemInHand.getJavaId() == this.session.getItemMappings().getStoredItems().goldenApple()) {
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

