/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.BasePiglinEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class PiglinEntity
extends BasePiglinEntity {
    public PiglinEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setBaby(BooleanEntityMetadata entityMetadata) {
        boolean isBaby = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityData.SCALE, Float.valueOf(isBaby ? 0.55f : 1.0f));
        this.setFlag(EntityFlag.BABY, isBaby);
        this.updateMountOffset();
    }

    public void setChargingCrossbow(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.CHARGING, entityMetadata.getPrimitiveValue());
    }

    public void setDancing(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.DANCING, entityMetadata.getPrimitiveValue());
    }

    @Override
    public void updateOffHand(GeyserSession session) {
        this.setFlag(EntityFlag.ADMIRING, session.getTagCache().shouldPiglinAdmire(session.getItemMappings().getMapping(this.offHand)));
        super.updateBedrockMetadata();
        super.updateOffHand(session);
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        InteractiveTag tag = super.testMobInteraction(hand, itemInHand);
        if (tag != InteractiveTag.NONE) {
            return tag;
        }
        return this.canGiveGoldTo(itemInHand) ? InteractiveTag.BARTER : InteractiveTag.NONE;
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        return this.canGiveGoldTo(itemInHand) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private boolean canGiveGoldTo(@Nonnull GeyserItemStack itemInHand) {
        return !this.getFlag(EntityFlag.BABY) && itemInHand.getJavaId() == this.session.getItemMappings().getStoredItems().goldIngot() && !this.getFlag(EntityFlag.ADMIRING);
    }
}

