/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.merchant;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.VillagerData;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import java.util.Optional;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.merchant.AbstractMerchantEntity;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.collection.Object2IntBiMap;

public class VillagerEntity
extends AbstractMerchantEntity {
    private static final int[] VILLAGER_PROFESSIONS = new int[15];
    private static final int[] VILLAGER_REGIONS = new int[7];
    private Vector3i bedPosition;
    private boolean canTradeWith;

    public VillagerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setVillagerData(EntityMetadata<VillagerData, ?> entityMetadata) {
        VillagerData villagerData = entityMetadata.getValue();
        int profession = VillagerEntity.getBedrockProfession(villagerData.getProfession());
        this.canTradeWith = profession != 14 && profession != 0;
        this.dirtyMetadata.put(EntityData.VARIANT, profession);
        this.dirtyMetadata.put(EntityData.MARK_VARIANT, VillagerEntity.getBedrockRegion(villagerData.getType()));
        this.dirtyMetadata.put(EntityData.TRADE_TIER, villagerData.getLevel() - 1);
    }

    @Override
    public Vector3i setBedPosition(EntityMetadata<Optional<Vector3i>, ?> entityMetadata) {
        this.bedPosition = super.setBedPosition(entityMetadata);
        return this.bedPosition;
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        if (!this.getFlag(EntityFlag.SLEEPING) || this.bedPosition == null) {
            super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
            return;
        }
        int blockId = this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.bedPosition);
        String fullIdentifier = (String)((Object2IntBiMap)BlockRegistries.JAVA_IDENTIFIERS.get()).get(blockId);
        int bedRotation = 0;
        float xOffset = 0.0f;
        float zOffset = 0.0f;
        if (fullIdentifier.contains("facing=south")) {
            bedRotation = 180;
            zOffset = -0.5f;
        } else if (fullIdentifier.contains("facing=east")) {
            bedRotation = 90;
            xOffset = -0.5f;
        } else if (fullIdentifier.contains("facing=west")) {
            bedRotation = 270;
            xOffset = 0.5f;
        } else if (fullIdentifier.contains("facing=north")) {
            zOffset = 0.5f;
        }
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        this.position = Vector3f.from((double)this.position.getX() + relX, (double)this.position.getY() + relY, (double)this.position.getZ() + relZ);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        moveEntityPacket.setRotation(Vector3f.from(0.0f, 0.0f, bedRotation));
        moveEntityPacket.setPosition(Vector3f.from(this.position.getX() + xOffset, this.position.getY(), this.position.getZ() + zOffset));
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(false);
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public static int getBedrockProfession(int javaProfession) {
        return javaProfession >= 0 && javaProfession < VILLAGER_PROFESSIONS.length ? VILLAGER_PROFESSIONS[javaProfession] : 0;
    }

    public static int getBedrockRegion(int javaRegion) {
        return javaRegion >= 0 && javaRegion < VILLAGER_REGIONS.length ? VILLAGER_REGIONS[javaRegion] : 0;
    }

    public boolean isCanTradeWith() {
        return this.canTradeWith;
    }

    static {
        VillagerEntity.VILLAGER_PROFESSIONS[0] = 0;
        VillagerEntity.VILLAGER_PROFESSIONS[1] = 8;
        VillagerEntity.VILLAGER_PROFESSIONS[2] = 11;
        VillagerEntity.VILLAGER_PROFESSIONS[3] = 6;
        VillagerEntity.VILLAGER_PROFESSIONS[4] = 7;
        VillagerEntity.VILLAGER_PROFESSIONS[5] = 1;
        VillagerEntity.VILLAGER_PROFESSIONS[6] = 2;
        VillagerEntity.VILLAGER_PROFESSIONS[7] = 4;
        VillagerEntity.VILLAGER_PROFESSIONS[8] = 12;
        VillagerEntity.VILLAGER_PROFESSIONS[9] = 5;
        VillagerEntity.VILLAGER_PROFESSIONS[10] = 13;
        VillagerEntity.VILLAGER_PROFESSIONS[11] = 14;
        VillagerEntity.VILLAGER_PROFESSIONS[12] = 3;
        VillagerEntity.VILLAGER_PROFESSIONS[13] = 10;
        VillagerEntity.VILLAGER_PROFESSIONS[14] = 9;
        VillagerEntity.VILLAGER_REGIONS[0] = 1;
        VillagerEntity.VILLAGER_REGIONS[1] = 2;
        VillagerEntity.VILLAGER_REGIONS[2] = 0;
        VillagerEntity.VILLAGER_REGIONS[3] = 3;
        VillagerEntity.VILLAGER_REGIONS[4] = 4;
        VillagerEntity.VILLAGER_REGIONS[5] = 5;
        VillagerEntity.VILLAGER_REGIONS[6] = 6;
    }
}

