/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.horse;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.MobArmorEquipmentPacket;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.horse.ChestedHorseEntity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;

public class LlamaEntity
extends ChestedHorseEntity {
    public LlamaEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityData.CONTAINER_STRENGTH_MODIFIER, 3);
    }

    public void setCarpetedColor(IntEntityMetadata entityMetadata) {
        MobArmorEquipmentPacket equipmentPacket = new MobArmorEquipmentPacket();
        equipmentPacket.setRuntimeEntityId(this.geyserId);
        int carpetIndex = entityMetadata.getPrimitiveValue();
        if (carpetIndex > -1 && carpetIndex <= 15) {
            equipmentPacket.setChestplate(this.session.getItemMappings().getCarpets().get(carpetIndex));
        } else {
            equipmentPacket.setChestplate(ItemData.AIR);
        }
        equipmentPacket.setBoots(ItemData.AIR);
        equipmentPacket.setHelmet(ItemData.AIR);
        equipmentPacket.setLeggings(ItemData.AIR);
        this.session.sendUpstreamPacket(equipmentPacket);
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return javaIdentifierStripped.equals("wheat") || javaIdentifierStripped.equals("hay_block");
    }
}

