/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.horse;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.google.common.collect.ImmutableSet;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerType;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAttributesPacket;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class AbstractHorseEntity
extends AnimalEntity {
    private static final Set<String> DONKEY_AND_HORSE_FOODS = ImmutableSet.of((Object)"golden_apple", (Object)"enchanted_golden_apple", (Object)"golden_carrot", (Object)"sugar", (Object)"apple", (Object)"wheat", (Object[])new String[]{"hay_block"});

    public AbstractHorseEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityData.CONTAINER_BASE_SIZE, this.getContainerBaseSize());
        this.setFlag(EntityFlag.WASD_CONTROLLED, true);
    }

    protected int getContainerBaseSize() {
        return 2;
    }

    @Override
    public void spawnEntity() {
        super.spawnEntity();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.getAttributes().add(GeyserAttributeType.HORSE_JUMP_STRENGTH.getAttribute(0.5f, 2.0f));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void setHorseFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        boolean tamed = (xd & 2) == 2;
        boolean saddled = (xd & 4) == 4;
        this.setFlag(EntityFlag.TAMED, tamed);
        this.setFlag(EntityFlag.SADDLED, saddled);
        this.setFlag(EntityFlag.EATING, (xd & 0x10) == 16);
        this.setFlag(EntityFlag.STANDING, (xd & 0x20) == 32);
        int horseFlags = 0;
        horseFlags = (xd & 0x40) == 64 ? horseFlags | 0x80 : horseFlags;
        horseFlags = (xd & 0x10) == 16 && (xd & 0x40) != 64 ? horseFlags | 0x20 : horseFlags;
        this.dirtyMetadata.put(EntityData.DISPLAY_ITEM, horseFlags);
        if ((xd & 0x40) == 64) {
            EntityEventPacket entityEventPacket = new EntityEventPacket();
            entityEventPacket.setRuntimeEntityId(this.geyserId);
            entityEventPacket.setType(EntityEventType.EATING_ITEM);
            entityEventPacket.setData(this.session.getItemMappings().getStoredItems().wheat().getBedrockId() << 16);
            this.session.sendUpstreamPacket(entityEventPacket);
        }
        this.dirtyMetadata.put(EntityData.CONTAINER_TYPE, tamed ? (byte)ContainerType.HORSE.getId() : (byte)0);
        this.setFlag(EntityFlag.CAN_POWER_JUMP, saddled);
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return DONKEY_AND_HORSE_FOODS.contains(javaIdentifierStripped);
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        return this.testHorseInteraction(hand, itemInHand);
    }

    @Nonnull
    protected final InteractiveTag testHorseInteraction(@Nonnull Hand hand, @Nonnull GeyserItemStack itemInHand) {
        boolean isBaby = this.isBaby();
        if (!isBaby) {
            if (this.getFlag(EntityFlag.TAMED) && this.session.isSneaking()) {
                return InteractiveTag.OPEN_CONTAINER;
            }
            if (!this.passengers.isEmpty()) {
                return super.testMobInteraction(hand, itemInHand);
            }
        }
        if (!itemInHand.isEmpty()) {
            if (this.canEat(itemInHand)) {
                return InteractiveTag.FEED;
            }
            if (this.testSaddle(itemInHand)) {
                return InteractiveTag.SADDLE;
            }
            if (!this.getFlag(EntityFlag.TAMED)) {
                return InteractiveTag.NONE;
            }
            if (this.testForChest(itemInHand)) {
                return InteractiveTag.ATTACH_CHEST;
            }
            if (this.additionalTestForInventoryOpen(itemInHand) || !isBaby && !this.getFlag(EntityFlag.SADDLED) && itemInHand.getJavaId() == this.session.getItemMappings().getStoredItems().saddle()) {
                return InteractiveTag.OPEN_CONTAINER;
            }
        }
        if (isBaby) {
            return super.testMobInteraction(hand, itemInHand);
        }
        return InteractiveTag.MOUNT;
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        return this.mobHorseInteract(hand, itemInHand);
    }

    @Nonnull
    protected final InteractionResult mobHorseInteract(@Nonnull Hand hand, @Nonnull GeyserItemStack itemInHand) {
        boolean isBaby = this.isBaby();
        if (!isBaby) {
            if (this.getFlag(EntityFlag.TAMED) && this.session.isSneaking()) {
                return InteractionResult.SUCCESS;
            }
            if (!this.passengers.isEmpty()) {
                return super.mobInteract(hand, itemInHand);
            }
        }
        if (!itemInHand.isEmpty()) {
            if (this.canEat(itemInHand)) {
                if (isBaby) {
                    this.playEntityEvent(EntityEventType.BABY_ANIMAL_FEED);
                }
                return InteractionResult.CONSUME;
            }
            if (this.testSaddle(itemInHand)) {
                return InteractionResult.SUCCESS;
            }
            if (!this.getFlag(EntityFlag.TAMED)) {
                return InteractionResult.SUCCESS;
            }
            if (this.testForChest(itemInHand)) {
                return InteractionResult.SUCCESS;
            }
            if (this.additionalTestForInventoryOpen(itemInHand) || !isBaby && !this.getFlag(EntityFlag.SADDLED) && itemInHand.getJavaId() == this.session.getItemMappings().getStoredItems().saddle()) {
                return InteractionResult.SUCCESS;
            }
        }
        if (isBaby) {
            return super.mobInteract(hand, itemInHand);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean testSaddle(@Nonnull GeyserItemStack itemInHand) {
        return this.isAlive() && !this.getFlag(EntityFlag.BABY) && this.getFlag(EntityFlag.TAMED);
    }

    protected boolean testForChest(@Nonnull GeyserItemStack itemInHand) {
        return false;
    }

    protected boolean additionalTestForInventoryOpen(@Nonnull GeyserItemStack itemInHand) {
        return itemInHand.getMapping(this.session).getJavaIdentifier().endsWith("_horse_armor");
    }

    protected final InteractiveTag testUndeadHorseInteraction(@Nonnull Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.TAMED)) {
            return InteractiveTag.NONE;
        }
        if (this.isBaby()) {
            return this.testHorseInteraction(hand, itemInHand);
        }
        if (this.session.isSneaking()) {
            return InteractiveTag.OPEN_CONTAINER;
        }
        if (!this.passengers.isEmpty()) {
            return this.testHorseInteraction(hand, itemInHand);
        }
        if (this.session.getItemMappings().getStoredItems().saddle() == itemInHand.getJavaId()) {
            return InteractiveTag.OPEN_CONTAINER;
        }
        if (this.testSaddle(itemInHand)) {
            return InteractiveTag.SADDLE;
        }
        return InteractiveTag.RIDE_HORSE;
    }

    protected final InteractionResult undeadHorseInteract(@Nonnull Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.TAMED)) {
            return InteractionResult.PASS;
        }
        if (this.isBaby()) {
            return this.mobHorseInteract(hand, itemInHand);
        }
        if (this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.passengers.isEmpty()) {
            return this.mobHorseInteract(hand, itemInHand);
        }
        return InteractionResult.SUCCESS;
    }
}

