/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class PigEntity
extends AnimalEntity {
    public PigEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return javaIdentifierStripped.equals("carrot") || javaIdentifierStripped.equals("potato") || javaIdentifierStripped.equals("beetroot");
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractiveTag.MOUNT;
        }
        InteractiveTag superTag = super.testMobInteraction(hand, itemInHand);
        if (superTag != InteractiveTag.NONE) {
            return superTag;
        }
        return EntityUtils.attemptToSaddle(this.session, this, itemInHand).consumesAction() ? InteractiveTag.SADDLE : InteractiveTag.NONE;
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        return EntityUtils.attemptToSaddle(this.session, this, itemInHand);
    }
}

