/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class PandaEntity
extends AnimalEntity {
    private Gene mainGene = Gene.NORMAL;
    private Gene hiddenGene = Gene.NORMAL;

    public PandaEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setEatingCounter(IntEntityMetadata entityMetadata) {
        int count = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.EATING, count > 0);
        this.dirtyMetadata.put(EntityData.EATING_COUNTER, count);
        if (count != 0) {
            EntityEventPacket packet = new EntityEventPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.setType(EntityEventType.EATING_ITEM);
            packet.setData(this.session.getItemMappings().getStoredItems().bamboo().getBedrockId() << 16);
            this.session.sendUpstreamPacket(packet);
        }
    }

    public void setMainGene(ByteEntityMetadata entityMetadata) {
        this.mainGene = Gene.fromId(entityMetadata.getPrimitiveValue());
        this.updateAppearance();
    }

    public void setHiddenGene(ByteEntityMetadata entityMetadata) {
        this.hiddenGene = Gene.fromId(entityMetadata.getPrimitiveValue());
        this.updateAppearance();
    }

    public void setPandaFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SNEEZING, (xd & 2) == 2);
        this.setFlag(EntityFlag.ROLLING, (xd & 4) == 4);
        this.setFlag(EntityFlag.SITTING, (xd & 8) == 8);
        this.dirtyMetadata.put(EntityData.SITTING_AMOUNT, Float.valueOf((xd & 8) == 8 ? 1.0f : 0.0f));
        this.dirtyMetadata.put(EntityData.SITTING_AMOUNT_PREVIOUS, Float.valueOf((xd & 8) == 8 ? 1.0f : 0.0f));
        this.setFlag(EntityFlag.LAYING_DOWN, (xd & 0x10) == 16);
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return javaIdentifierStripped.equals("bamboo");
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.mainGene == Gene.WORRIED && this.session.isThunder()) {
            return InteractiveTag.NONE;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.mainGene == Gene.WORRIED && this.session.isThunder()) {
            return InteractionResult.PASS;
        }
        if (this.getFlag(EntityFlag.LAYING_DOWN)) {
            return InteractionResult.SUCCESS;
        }
        if (this.canEat(itemInHand)) {
            if (this.getFlag(EntityFlag.BABY)) {
                this.playEntityEvent(EntityEventType.BABY_ANIMAL_FEED);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected boolean canBeLeashed() {
        return false;
    }

    private void updateAppearance() {
        if (this.mainGene.isRecessive) {
            if (this.mainGene == this.hiddenGene) {
                this.dirtyMetadata.put(EntityData.VARIANT, this.mainGene.ordinal());
            } else {
                this.dirtyMetadata.put(EntityData.VARIANT, Gene.NORMAL.ordinal());
            }
        } else {
            this.dirtyMetadata.put(EntityData.VARIANT, this.mainGene.ordinal());
        }
    }

    static enum Gene {
        NORMAL(false),
        LAZY(false),
        WORRIED(false),
        PLAYFUL(false),
        BROWN(true),
        WEAK(true),
        AGGRESSIVE(false);

        private static final Gene[] VALUES;
        private final boolean isRecessive;

        private Gene(boolean isRecessive) {
            this.isRecessive = isRecessive;
        }

        @Nullable
        private static Gene fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                return NORMAL;
            }
            return VALUES[id];
        }

        static {
            VALUES = Gene.values();
        }
    }
}

