/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;

public class GoatEntity
extends AnimalEntity {
    private static final float LONG_JUMPING_HEIGHT = 0.90999997f;
    private static final float LONG_JUMPING_WIDTH = 0.63f;
    private boolean isScreamer;
    private boolean hasLeftHorn;
    private boolean hasRightHorn;

    public GoatEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setScreamer(BooleanEntityMetadata entityMetadata) {
        this.isScreamer = entityMetadata.getPrimitiveValue();
    }

    @Override
    protected void setDimensions(Pose pose) {
        if (pose == Pose.LONG_JUMPING) {
            this.setBoundingBoxWidth(0.63f);
            this.setBoundingBoxHeight(0.90999997f);
        } else {
            super.setDimensions(pose);
        }
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.BABY) && itemInHand.getMapping(this.session).getJavaIdentifier().equals("minecraft:bucket")) {
            this.session.playSoundEvent(this.isScreamer ? SoundEvent.MILK_SCREAMER : SoundEvent.MILK, this.position);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }

    public void setHasLeftHorn(BooleanEntityMetadata entityMetadata) {
        this.hasLeftHorn = entityMetadata.getPrimitiveValue();
        this.setHornCount();
    }

    public void setHasRightHorn(BooleanEntityMetadata entityMetadata) {
        this.hasRightHorn = entityMetadata.getPrimitiveValue();
        this.setHornCount();
    }

    private void setHornCount() {
        this.dirtyMetadata.put(EntityData.GOAT_HORN_COUNT, (this.hasLeftHorn ? 1 : 0) + (this.hasRightHorn ? 1 : 0));
    }
}

