/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.OptionalInt;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;

public class FrogEntity
extends AnimalEntity {
    public FrogEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.JUMP_GOAL_JUMP, pose == Pose.LONG_JUMPING);
        this.setFlag(EntityFlag.CROAKING, pose == Pose.CROAKING);
        this.setFlag(EntityFlag.EAT_MOB, pose == Pose.USING_TONGUE);
        super.setPose(pose);
    }

    public void setFrogVariant(IntEntityMetadata entityMetadata) {
        int variant = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityData.VARIANT, switch (variant) {
            case 1 -> 2;
            case 2 -> 1;
            default -> variant;
        });
    }

    public void setTongueTarget(ObjectEntityMetadata<OptionalInt> entityMetadata) {
        OptionalInt entityId = entityMetadata.getValue();
        if (entityId.isPresent()) {
            Entity entity = this.session.getEntityCache().getEntityByJavaId(entityId.getAsInt());
            if (entity != null) {
                this.dirtyMetadata.put(EntityData.TARGET_EID, entity.getGeyserId());
            }
        } else {
            this.dirtyMetadata.put(EntityData.TARGET_EID, 0L);
        }
    }

    @Override
    public boolean canEat(String javaIdentifierStripped, ItemMapping mapping) {
        return mapping.getJavaId() == this.session.getItemMappings().getStoredItems().slimeBall();
    }
}

