/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class CowEntity
extends AnimalEntity {
    public CowEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    @Nonnull
    protected InteractiveTag testMobInteraction(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.BABY) || !itemInHand.getMapping(this.session).getJavaIdentifier().equals("minecraft:bucket")) {
            return super.testMobInteraction(hand, itemInHand);
        }
        return InteractiveTag.MILK;
    }

    @Override
    @Nonnull
    protected InteractionResult mobInteract(Hand hand, @Nonnull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.BABY) || !itemInHand.getMapping(this.session).getJavaIdentifier().equals("minecraft:bucket")) {
            return super.mobInteract(hand, itemInHand);
        }
        this.session.playSoundEvent(SoundEvent.MILK, this.position);
        return InteractionResult.SUCCESS;
    }
}

