/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.MoveEntityDeltaPacket;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.living.WaterEntity;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.session.GeyserSession;

public class SquidEntity
extends WaterEntity
implements Tickable {
    private float targetPitch;
    private float targetYaw;
    private boolean inWater;

    public SquidEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void tick() {
        boolean pitchChanged;
        boolean yawChanged;
        float oldPitch = this.pitch;
        if (this.inWater) {
            float oldYaw = this.yaw;
            this.pitch += (this.targetPitch - this.pitch) * 0.1f;
            this.yaw += (this.targetYaw - this.yaw) * 0.1f;
            yawChanged = oldYaw != this.yaw;
        } else {
            this.pitch += (-90.0f - this.pitch) * 0.02f;
            yawChanged = false;
        }
        boolean bl = pitchChanged = oldPitch != this.pitch;
        if (pitchChanged || yawChanged) {
            MoveEntityDeltaPacket packet = new MoveEntityDeltaPacket();
            packet.setRuntimeEntityId(this.geyserId);
            if (pitchChanged) {
                packet.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
                packet.setPitch(this.pitch);
            }
            if (yawChanged) {
                packet.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
                packet.setYaw(this.yaw);
            }
            this.session.sendUpstreamPacket(packet);
        }
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        this.checkInWater();
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsolute(position, yaw, pitch, headYaw, isOnGround, teleported);
        this.checkInWater();
    }

    @Override
    public void setYaw(float yaw) {
        if (!this.inWater) {
            this.yaw = yaw;
        }
    }

    @Override
    public void setPitch(float pitch) {
    }

    @Override
    public void setHeadYaw(float headYaw) {
    }

    @Override
    public void setMotion(Vector3f motion) {
        super.setMotion(motion);
        double horizontalSpeed = Math.sqrt(motion.getX() * motion.getX() + motion.getZ() * motion.getZ());
        this.targetPitch = (float)Math.toDegrees(-Math.atan2(horizontalSpeed, motion.getY()));
        this.targetYaw = (float)Math.toDegrees(-Math.atan2(motion.getX(), motion.getZ()));
    }

    @Override
    public Vector3f getBedrockRotation() {
        return Vector3f.from(this.getPitch(), this.getYaw(), this.getYaw());
    }

    @Override
    protected boolean canBeLeashed() {
        return this.isNotLeashed();
    }

    private void checkInWater() {
        int block;
        this.inWater = this.getFlag(EntityFlag.RIDING) ? false : BlockStateValues.getWaterLevel(block = this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.position.toInt())) != -1;
    }
}

