/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class MobEntity
extends LivingEntity {
    private long leashHolderBedrockId;

    public MobEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setLeashHolderBedrockId(-1L);
    }

    public void setMobFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.NO_AI, (xd & 1) == 1);
    }

    public void setLeashHolderBedrockId(long bedrockId) {
        this.leashHolderBedrockId = bedrockId;
        this.dirtyMetadata.put(EntityData.LEASH_HOLDER_EID, bedrockId);
    }

    @Override
    protected final InteractiveTag testInteraction(Hand hand) {
        InteractionResult result;
        if (!this.isAlive()) {
            return InteractiveTag.NONE;
        }
        if (this.leashHolderBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return InteractiveTag.REMOVE_LEASH;
        }
        GeyserItemStack itemStack = this.session.getPlayerInventory().getItemInHand(hand);
        StoredItemMappings storedItems = this.session.getItemMappings().getStoredItems();
        if (itemStack.getJavaId() == storedItems.lead() && this.canBeLeashed()) {
            return InteractiveTag.LEASH;
        }
        if (itemStack.getJavaId() == storedItems.nameTag() && (result = this.checkInteractWithNameTag(itemStack)).consumesAction()) {
            return InteractiveTag.NAME;
        }
        InteractiveTag tag = this.testMobInteraction(hand, itemStack);
        return tag != InteractiveTag.NONE ? tag : super.testInteraction(hand);
    }

    @Override
    public final InteractionResult interact(Hand hand) {
        if (!this.isAlive()) {
            return InteractionResult.PASS;
        }
        if (this.leashHolderBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return InteractionResult.SUCCESS;
        }
        GeyserItemStack itemInHand = this.session.getPlayerInventory().getItemInHand(hand);
        InteractionResult result = this.checkPriorityInteractions(itemInHand);
        if (result.consumesAction()) {
            return result;
        }
        InteractionResult mobResult = this.mobInteract(hand, itemInHand);
        return mobResult.consumesAction() ? mobResult : super.interact(hand);
    }

    private InteractionResult checkPriorityInteractions(GeyserItemStack itemInHand) {
        StoredItemMappings storedItems = this.session.getItemMappings().getStoredItems();
        if (itemInHand.getJavaId() == storedItems.lead() && this.canBeLeashed()) {
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.getJavaId() == storedItems.nameTag()) {
            InteractionResult result = this.checkInteractWithNameTag(itemInHand);
            if (result.consumesAction()) {
                return result;
            }
        } else {
            ItemMapping mapping = itemInHand.getMapping(this.session);
            if (mapping.getJavaIdentifier().endsWith("_spawn_egg")) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    protected InteractiveTag testMobInteraction(@Nonnull Hand hand, @Nonnull GeyserItemStack itemInHand) {
        return InteractiveTag.NONE;
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Hand hand, @Nonnull GeyserItemStack itemInHand) {
        return InteractionResult.PASS;
    }

    protected boolean canBeLeashed() {
        return this.isNotLeashed() && !this.isEnemy();
    }

    protected final boolean isNotLeashed() {
        return this.leashHolderBedrockId == -1L;
    }

    protected boolean isEnemy() {
        return false;
    }

    public long getLeashHolderBedrockId() {
        return this.leashHolderBedrockId;
    }
}

