/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.type.PaintingType;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.packet.AddPaintingPacket;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;

public class PaintingEntity
extends Entity {
    private static final double OFFSET = -0.46875;
    private final Direction direction;

    public PaintingEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, Direction direction) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.direction = direction;
    }

    @Override
    public void spawnEntity() {
    }

    public void setPaintingType(ObjectEntityMetadata<PaintingType> entityMetadata) {
        org.geysermc.geyser.level.PaintingType type = org.geysermc.geyser.level.PaintingType.getByPaintingType(entityMetadata.getValue());
        AddPaintingPacket addPaintingPacket = new AddPaintingPacket();
        addPaintingPacket.setUniqueEntityId(this.geyserId);
        addPaintingPacket.setRuntimeEntityId(this.geyserId);
        addPaintingPacket.setMotive(type.getBedrockName());
        addPaintingPacket.setPosition(this.fixOffset(type));
        addPaintingPacket.setDirection(switch (this.direction) {
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 1;
            case Direction.NORTH -> 2;
            case Direction.EAST -> 3;
            default -> 0;
        });
        this.session.sendUpstreamPacket(addPaintingPacket);
        this.valid = true;
        this.session.getGeyser().getLogger().debug("Spawned painting on " + this.position);
    }

    @Override
    public void updateHeadLookRotation(float headYaw) {
    }

    private Vector3f fixOffset(org.geysermc.geyser.level.PaintingType paintingName) {
        Vector3f position = this.position;
        position = position.add(0.5, 0.5, 0.5);
        double widthOffset = paintingName.getWidth() > 1 ? 0.5 : 0.0;
        double heightOffset = paintingName.getHeight() > 1 && paintingName.getHeight() != 3 ? 0.5 : 0.0;
        return switch (this.direction) {
            case Direction.SOUTH -> position.add(widthOffset, heightOffset, -0.46875);
            case Direction.WEST -> position.add(0.46875, heightOffset, widthOffset);
            case Direction.NORTH -> position.add(-widthOffset, heightOffset, 0.46875);
            case Direction.EAST -> position.add(-0.46875, heightOffset, -widthOffset);
            default -> position;
        };
    }
}

