/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.level.particle.Particle;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import java.util.UUID;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;

public class AreaEffectCloudEntity
extends Entity {
    public AreaEffectCloudEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityData.AREA_EFFECT_CLOUD_DURATION, Integer.MAX_VALUE);
        this.dirtyMetadata.put(EntityData.AREA_EFFECT_CLOUD_RADIUS, Float.valueOf(0.0f));
        this.dirtyMetadata.put(EntityData.AREA_EFFECT_CLOUD_CHANGE_RATE, Float.valueOf(Float.MIN_VALUE));
        this.dirtyMetadata.put(EntityData.AREA_EFFECT_CLOUD_CHANGE_ON_PICKUP, Float.valueOf(Float.MIN_VALUE));
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
    }

    public void setRadius(FloatEntityMetadata entityMetadata) {
        float value = Math.max(entityMetadata.getPrimitiveValue(), 0.5f);
        this.dirtyMetadata.put(EntityData.AREA_EFFECT_CLOUD_RADIUS, Float.valueOf(value));
        this.dirtyMetadata.put(EntityData.BOUNDING_BOX_WIDTH, Float.valueOf(2.0f * value));
    }

    public void setParticle(EntityMetadata<Particle, ?> entityMetadata) {
        Particle particle = entityMetadata.getValue();
        int particleId = Registries.PARTICLES.map(particle.getType(), mapping -> mapping.getParticleId(this.session)).orElse(-1);
        if (particleId != -1) {
            this.dirtyMetadata.put(EntityData.AREA_EFFECT_CLOUD_PARTICLE_ID, particleId);
        }
    }
}

