/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.dump;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.floodgate.util.FloodgateInfoHolder;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.util.CpuUtils;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.relocate.jackson.annotation.JsonIgnore;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class DumpInfo {
    @JsonIgnore
    private static final long MEGABYTE = 0x100000L;
    private final VersionInfo versionInfo;
    private final int cpuCount;
    private final String cpuName;
    private final Locale systemLocale;
    private final String systemEncoding;
    private Properties gitInfo;
    private final GeyserConfiguration config;
    private final Floodgate floodgate;
    private final Object2IntMap<DeviceOs> userPlatforms;
    private final HashInfo hashInfo;
    private final RamInfo ramInfo;
    private LogsInfo logsInfo;
    private final BootstrapDumpInfo bootstrapInfo;
    private final FlagsInfo flagsInfo;

    public DumpInfo(boolean addLog) {
        String sha256Hash;
        String md5Hash;
        block13: {
            this.versionInfo = new VersionInfo();
            this.cpuCount = Runtime.getRuntime().availableProcessors();
            this.cpuName = CpuUtils.tryGetProcessorName();
            this.systemLocale = Locale.getDefault();
            this.systemEncoding = System.getProperty("file.encoding");
            try (InputStream stream2 = GeyserImpl.getInstance().getBootstrap().getResource("git.properties");){
                this.gitInfo = new Properties();
                this.gitInfo.load(stream2);
            }
            catch (IOException stream2) {
                // empty catch block
            }
            this.config = GeyserImpl.getInstance().getConfig();
            this.floodgate = new Floodgate();
            md5Hash = "unknown";
            sha256Hash = "unknown";
            try {
                File file = new File(DumpInfo.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                ByteSource byteSource = com.google.common.io.Files.asByteSource((File)file);
                md5Hash = byteSource.hash(Hashing.md5()).toString();
                sha256Hash = byteSource.hash(Hashing.sha256()).toString();
            }
            catch (Exception e) {
                if (!GeyserImpl.getInstance().getConfig().isDebugMode()) break block13;
                e.printStackTrace();
            }
        }
        this.hashInfo = new HashInfo(md5Hash, sha256Hash);
        this.ramInfo = new RamInfo();
        if (addLog) {
            this.logsInfo = new LogsInfo();
        }
        this.userPlatforms = new Object2IntOpenHashMap();
        for (GeyserSession session : GeyserImpl.getInstance().getSessionManager().getAllSessions()) {
            DeviceOs device = session.getClientData().getDeviceOs();
            this.userPlatforms.put((Object)device, this.userPlatforms.getOrDefault((Object)device, 0) + 1);
        }
        this.bootstrapInfo = GeyserImpl.getInstance().getBootstrap().getDumpInfo();
        this.flagsInfo = new FlagsInfo();
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public String getCpuName() {
        return this.cpuName;
    }

    public Locale getSystemLocale() {
        return this.systemLocale;
    }

    public String getSystemEncoding() {
        return this.systemEncoding;
    }

    public Properties getGitInfo() {
        return this.gitInfo;
    }

    public GeyserConfiguration getConfig() {
        return this.config;
    }

    public Floodgate getFloodgate() {
        return this.floodgate;
    }

    public Object2IntMap<DeviceOs> getUserPlatforms() {
        return this.userPlatforms;
    }

    public HashInfo getHashInfo() {
        return this.hashInfo;
    }

    public RamInfo getRamInfo() {
        return this.ramInfo;
    }

    public LogsInfo getLogsInfo() {
        return this.logsInfo;
    }

    public BootstrapDumpInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    public FlagsInfo getFlagsInfo() {
        return this.flagsInfo;
    }

    public static class VersionInfo {
        private final String name;
        private final String version;
        private final String javaName = System.getProperty("java.vm.name");
        private final String javaVendor = System.getProperty("java.vendor");
        private final String javaVersion = ManagementFactory.getRuntimeMXBean().getVmVersion();
        private final String architecture = System.getProperty("os.arch");
        private final String operatingSystem = System.getProperty("os.name");
        private final String operatingSystemVersion = System.getProperty("os.version");
        private final NetworkInfo network = new NetworkInfo();
        private final MCInfo mcInfo = new MCInfo();

        VersionInfo() {
            this.name = "Geyser";
            this.version = "2.0.6-SNAPSHOT (git-eab92da98884308b6e4b4a5deb1de97b2fbd3c6e-eab92da)";
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public String getJavaVendor() {
            return this.javaVendor;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getOperatingSystem() {
            return this.operatingSystem;
        }

        public String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        public NetworkInfo getNetwork() {
            return this.network;
        }

        public MCInfo getMcInfo() {
            return this.mcInfo;
        }
    }

    public static class Floodgate {
        private final Properties gitInfo = FloodgateInfoHolder.getGitProperties();
        private final Object config = FloodgateInfoHolder.getConfig();

        Floodgate() {
        }

        public Properties getGitInfo() {
            return this.gitInfo;
        }

        public Object getConfig() {
            return this.config;
        }
    }

    public static class HashInfo {
        private final String md5Hash;
        private final String sha256Hash;

        public HashInfo(String md5Hash, String sha256Hash) {
            this.md5Hash = md5Hash;
            this.sha256Hash = sha256Hash;
        }

        public String getMd5Hash() {
            return this.md5Hash;
        }

        public String getSha256Hash() {
            return this.sha256Hash;
        }
    }

    public static class RamInfo {
        private final long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        private final long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        private final long max = Runtime.getRuntime().maxMemory() / 0x100000L;

        RamInfo() {
        }

        public long getFree() {
            return this.free;
        }

        public long getTotal() {
            return this.total;
        }

        public long getMax() {
            return this.max;
        }
    }

    public static class LogsInfo {
        private String link;

        public LogsInfo() {
            try {
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("content", FileUtils.readAllLines(GeyserImpl.getInstance().getBootstrap().getLogsPath()).collect(Collectors.joining("\n")));
                JsonNode logData = GeyserImpl.JSON_MAPPER.readTree(WebUtils.postForm("https://api.mclo.gs/1/log", fields));
                this.link = logData.get("url").textValue();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getLink() {
            return this.link;
        }
    }

    public static class FlagsInfo {
        private final List<String> flags = ManagementFactory.getRuntimeMXBean().getInputArguments();

        FlagsInfo() {
        }

        public List<String> getFlags() {
            return this.flags;
        }
    }

    public static class MCInfo {
        private final List<String> bedrockVersions = MinecraftProtocol.SUPPORTED_BEDROCK_CODECS.stream().map(BedrockPacketCodec::getMinecraftVersion).toList();
        private final List<Integer> bedrockProtocols = MinecraftProtocol.SUPPORTED_BEDROCK_CODECS.stream().map(BedrockPacketCodec::getProtocolVersion).toList();
        private final int defaultBedrockProtocol = MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion();
        private final List<String> javaVersions = MinecraftProtocol.getJavaVersions();
        private final int javaProtocol = MinecraftProtocol.getJavaProtocolVersion();

        MCInfo() {
        }

        public List<String> getBedrockVersions() {
            return this.bedrockVersions;
        }

        public List<Integer> getBedrockProtocols() {
            return this.bedrockProtocols;
        }

        public int getDefaultBedrockProtocol() {
            return this.defaultBedrockProtocol;
        }

        public List<String> getJavaVersions() {
            return this.javaVersions;
        }

        public int getJavaProtocol() {
            return this.javaProtocol;
        }
    }

    public static class NetworkInfo {
        private final boolean dockerCheck;
        private String internalIP;

        NetworkInfo() {
            if (AsteriskSerializer.showSensitive) {
                try {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress("geysermc.org", 80));
                    this.internalIP = socket.getLocalAddress().getHostAddress();
                }
                catch (IOException e1) {
                    try {
                        this.internalIP = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            } else {
                this.internalIP = "***";
            }
            this.dockerCheck = this.checkDockerBasic();
        }

        private boolean checkDockerBasic() {
            try {
                String output;
                String OS = System.getProperty("os.name").toLowerCase();
                if ((OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0) && (output = new String(Files.readAllBytes(Paths.get("/proc/1/cgroup", new String[0])))).contains("docker")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public boolean isDockerCheck() {
            return this.dockerCheck;
        }

        public String getInternalIP() {
            return this.internalIP;
        }
    }
}

