/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.configuration.EmoteOffhandWorkaroundOption;
import org.geysermc.geyser.network.CIDRMatcher;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.relocate.jackson.annotation.JsonIgnore;

public interface GeyserConfiguration {
    public static final int CURRENT_CONFIG_VERSION = 4;

    public IBedrockConfiguration getBedrock();

    public IRemoteConfiguration getRemote();

    public List<String> getSavedUserLogins();

    @Deprecated
    public Map<String, ? extends IUserAuthenticationInfo> getUserAuths();

    public boolean isCommandSuggestions();

    @JsonIgnore
    public boolean isPassthroughMotd();

    @JsonIgnore
    public boolean isPassthroughProtocolName();

    @JsonIgnore
    public boolean isPassthroughPlayerCounts();

    @JsonIgnore
    public boolean isLegacyPingPassthrough();

    public int getPingPassthroughInterval();

    public boolean isForwardPlayerPing();

    public int getMaxPlayers();

    public boolean isDebugMode();

    public boolean isAllowThirdPartyCapes();

    public boolean isAllowThirdPartyEars();

    public String getShowCooldown();

    public boolean isShowCoordinates();

    public boolean isDisableBedrockScaffolding();

    public boolean isAlwaysQuickChangeArmor();

    public EmoteOffhandWorkaroundOption getEmoteOffhandWorkaround();

    public String getDefaultLocale();

    public Path getFloodgateKeyPath();

    public boolean isAddNonBedrockItems();

    public boolean isAboveBedrockNetherBuilding();

    public boolean isForceResourcePacks();

    public boolean isXboxAchievementsEnabled();

    public int getCacheImages();

    public boolean isAllowCustomSkulls();

    public int getMaxVisibleCustomSkulls();

    public int getCustomSkullRenderDistance();

    public IMetricsInfo getMetrics();

    public int getPendingAuthenticationTimeout();

    public int getScoreboardPacketThreshold();

    public boolean isEnableProxyConnections();

    public int getMtu();

    public boolean isUseDirectConnection();

    public int getConfigVersion();

    public static void checkGeyserConfiguration(GeyserConfiguration geyserConfig, GeyserLogger geyserLogger) {
        if (geyserConfig.getConfigVersion() < 4) {
            geyserLogger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.config.outdated", new Object[0]));
        } else if (geyserConfig.getConfigVersion() > 4) {
            geyserLogger.warning(GeyserLocale.getLocaleStringLog("geyser.bootstrap.config.too_new", new Object[0]));
        }
    }

    public static interface IMetricsInfo {
        public boolean isEnabled();

        public String getUniqueId();
    }

    public static interface IUserAuthenticationInfo {
        public String getEmail();

        public String getPassword();

        @Deprecated
        public boolean isMicrosoftAccount();
    }

    public static interface IRemoteConfiguration {
        public String getAddress();

        public int getPort();

        public void setAddress(String var1);

        public void setPort(int var1);

        public AuthType getAuthType();

        public boolean isPasswordAuthentication();

        public boolean isUseProxyProtocol();

        public boolean isForwardHost();
    }

    public static interface IBedrockConfiguration {
        public String getAddress();

        public int getPort();

        public boolean isCloneRemotePort();

        public String getMotd1();

        public String getMotd2();

        public String getServerName();

        public int getCompressionLevel();

        public boolean isEnableProxyProtocol();

        public List<String> getProxyProtocolWhitelistedIPs();

        public List<CIDRMatcher> getWhitelistedIPsMatchers();
    }
}

