/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandSender;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.defaults.AdvancedTooltipsCommand;
import org.geysermc.geyser.command.defaults.AdvancementsCommand;
import org.geysermc.geyser.command.defaults.ConnectionTestCommand;
import org.geysermc.geyser.command.defaults.DumpCommand;
import org.geysermc.geyser.command.defaults.HelpCommand;
import org.geysermc.geyser.command.defaults.ListCommand;
import org.geysermc.geyser.command.defaults.OffhandCommand;
import org.geysermc.geyser.command.defaults.ReloadCommand;
import org.geysermc.geyser.command.defaults.SettingsCommand;
import org.geysermc.geyser.command.defaults.StatisticsCommand;
import org.geysermc.geyser.command.defaults.StopCommand;
import org.geysermc.geyser.command.defaults.VersionCommand;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public abstract class CommandManager {
    private final Map<String, GeyserCommand> commands = new HashMap<String, GeyserCommand>();
    private final GeyserImpl geyser;

    public CommandManager(GeyserImpl geyser) {
        this.geyser = geyser;
        this.registerCommand(new HelpCommand(geyser, "help", "geyser.commands.help.desc", "geyser.command.help"));
        this.registerCommand(new ListCommand(geyser, "list", "geyser.commands.list.desc", "geyser.command.list"));
        this.registerCommand(new ReloadCommand(geyser, "reload", "geyser.commands.reload.desc", "geyser.command.reload"));
        this.registerCommand(new OffhandCommand(geyser, "offhand", "geyser.commands.offhand.desc", "geyser.command.offhand"));
        this.registerCommand(new DumpCommand(geyser, "dump", "geyser.commands.dump.desc", "geyser.command.dump"));
        this.registerCommand(new VersionCommand(geyser, "version", "geyser.commands.version.desc", "geyser.command.version"));
        this.registerCommand(new SettingsCommand(geyser, "settings", "geyser.commands.settings.desc", "geyser.command.settings"));
        this.registerCommand(new StatisticsCommand(geyser, "statistics", "geyser.commands.statistics.desc", "geyser.command.statistics"));
        this.registerCommand(new AdvancementsCommand("advancements", "geyser.commands.advancements.desc", "geyser.command.advancements"));
        this.registerCommand(new AdvancedTooltipsCommand("tooltips", "geyser.commands.advancedtooltips.desc", "geyser.command.tooltips"));
        this.registerCommand(new ConnectionTestCommand(geyser, "connectiontest", "geyser.commands.connectiontest.desc", "geyser.command.connectiontest"));
        if (GeyserImpl.getInstance().getPlatformType() == PlatformType.STANDALONE) {
            this.registerCommand(new StopCommand(geyser, "stop", "geyser.commands.stop.desc", "geyser.command.stop"));
        }
    }

    public void registerCommand(GeyserCommand command) {
        this.commands.put(command.getName(), command);
        this.geyser.getLogger().debug(GeyserLocale.getLocaleStringLog("geyser.commands.registered", command.getName()));
        if (command.getAliases().isEmpty()) {
            return;
        }
        for (String alias : command.getAliases()) {
            this.commands.put(alias, command);
        }
    }

    public void runCommand(CommandSender sender, String command) {
        String[] args;
        String label;
        if (!command.startsWith("geyser ")) {
            return;
        }
        if (!(command = command.trim().replace("geyser ", "")).contains(" ")) {
            label = command.toLowerCase();
            args = new String[]{};
        } else {
            String[] stringArray;
            label = command.substring(0, command.indexOf(" ")).toLowerCase();
            String argLine = command.substring(command.indexOf(" ") + 1);
            if (argLine.contains(" ")) {
                stringArray = argLine.split(" ");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = argLine;
            }
            args = stringArray;
        }
        GeyserCommand cmd = this.commands.get(label);
        if (cmd == null) {
            this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.invalid", new Object[0]));
            return;
        }
        if (sender instanceof GeyserSession) {
            cmd.execute((GeyserSession)sender, sender, args);
        } else if (!cmd.isBedrockOnly()) {
            cmd.execute(null, sender, args);
        } else {
            this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.command.bedrock_only", new Object[0]));
        }
    }

    public List<String> getCommandNames() {
        return Arrays.asList(this.geyser.getCommandManager().getCommands().keySet().toArray(new String[0]));
    }

    public abstract String getDescription(String var1);

    public Map<String, GeyserCommand> getCommands() {
        return this.commands;
    }
}

