/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import com.github.steveice10.packetlib.tcp.TcpSession;
import com.nukkitx.network.raknet.RakNetConstants;
import com.nukkitx.network.util.EventLoops;
import com.nukkitx.protocol.bedrock.BedrockServer;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.api.Geyser;
import org.geysermc.common.PlatformType;
import org.geysermc.floodgate.crypto.AesCipher;
import org.geysermc.floodgate.crypto.AesKeyProducer;
import org.geysermc.floodgate.crypto.Base64Topping;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.news.NewsItemAction;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.command.CommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.network.ConnectorServerEventHandler;
import org.geysermc.geyser.pack.ResourcePack;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.session.SessionManager;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.skin.FloodgateSkinUploader;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.Metrics;
import org.geysermc.geyser.util.NewsHandler;
import org.geysermc.geyser.util.VersionCheckUtils;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.relocate.jackson.core.JsonParser;
import org.geysermc.relocate.jackson.core.type.TypeReference;
import org.geysermc.relocate.jackson.databind.DeserializationFeature;
import org.geysermc.relocate.jackson.databind.ObjectMapper;

public class GeyserImpl
implements GeyserApi {
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(JsonParser.Feature.IGNORE_UNDEFINED).enable(JsonParser.Feature.ALLOW_COMMENTS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
    public static final String NAME = "Geyser";
    public static final String GIT_VERSION = "git-eab92da98884308b6e4b4a5deb1de97b2fbd3c6e-eab92da";
    public static final String VERSION = "2.0.6-SNAPSHOT (git-eab92da98884308b6e4b4a5deb1de97b2fbd3c6e-eab92da)";
    public static final String OAUTH_CLIENT_ID = "204cefd1-4818-4de1-b98d-513fae875d88";
    private static final String IP_REGEX = "\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b";
    private final SessionManager sessionManager = new SessionManager();
    private static boolean shouldStartListener = true;
    private FloodgateCipher cipher;
    private FloodgateSkinUploader skinUploader;
    private NewsHandler newsHandler;
    private volatile boolean shuttingDown = false;
    private ScheduledExecutorService scheduledThread;
    private BedrockServer bedrockServer;
    private final PlatformType platformType;
    private final GeyserBootstrap bootstrap;
    private Metrics metrics;
    private PendingMicrosoftAuthentication pendingMicrosoftAuthentication;
    private Map<String, String> savedRefreshTokens;
    private static GeyserImpl instance;

    private GeyserImpl(PlatformType platformType, GeyserBootstrap bootstrap) {
        instance = this;
        Geyser.set(this);
        this.platformType = platformType;
        this.bootstrap = bootstrap;
        long startupTime = System.currentTimeMillis();
        GeyserLocale.finalizeDefaultLocale(this);
        GeyserLogger logger = bootstrap.getGeyserLogger();
        logger.info("******************************************");
        logger.info("");
        logger.info(GeyserLocale.getLocaleStringLog("geyser.core.load", NAME, VERSION));
        logger.info("");
        logger.info("******************************************");
        BlockRegistries.init();
        Registries.init();
        EntityDefinitions.init();
        ItemTranslator.init();
        MessageTranslator.init();
        MinecraftLocale.init();
        this.start();
        GeyserConfiguration config = bootstrap.getGeyserConfig();
        boolean isGui = false;
        if (platformType == PlatformType.STANDALONE) {
            try {
                Class<?> cls = Class.forName("org.geysermc.geyser.platform.standalone.GeyserStandaloneBootstrap");
                isGui = (Boolean)cls.getMethod("isUseGui", new Class[0]).invoke(cls.cast(bootstrap), new Object[0]);
            }
            catch (Exception e) {
                logger.debug("Failed detecting if standalone is using a GUI; if this is a GeyserConnect instance this can be safely ignored.");
            }
        }
        double completeTime = (double)(System.currentTimeMillis() - startupTime) / 1000.0;
        String message = GeyserLocale.getLocaleStringLog("geyser.core.finish.done", new DecimalFormat("#.###").format(completeTime)) + " ";
        message = isGui ? message + GeyserLocale.getLocaleStringLog("geyser.core.finish.gui", new Object[0]) : message + GeyserLocale.getLocaleStringLog("geyser.core.finish.console", new Object[0]);
        logger.info(message);
        if (platformType == PlatformType.STANDALONE) {
            logger.warning(GeyserLocale.getLocaleStringLog("geyser.core.movement_warn", new Object[0]));
        } else if (config.getRemote().getAuthType() == AuthType.FLOODGATE) {
            VersionCheckUtils.checkForOutdatedFloodgate(logger);
        }
    }

    private void start() {
        String[] record;
        String remoteAddress;
        this.scheduledThread = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("Geyser Scheduled Thread"));
        GeyserLogger logger = this.bootstrap.getGeyserLogger();
        GeyserConfiguration config = this.bootstrap.getGeyserConfig();
        ScoreboardUpdater.init();
        SkinProvider.registerCacheImageTask(this);
        ResourcePack.loadPacks();
        if (this.platformType != PlatformType.STANDALONE && config.getRemote().getAddress().equals("auto")) {
            try {
                config.getRemote().setAddress(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException ex) {
                logger.debug("Unknown host when trying to find localhost.");
                if (config.isDebugMode()) {
                    ex.printStackTrace();
                }
                config.getRemote().setAddress(InetAddress.getLoopbackAddress().getHostAddress());
            }
        }
        if (!(remoteAddress = config.getRemote().getAddress()).matches(IP_REGEX) && !remoteAddress.equalsIgnoreCase("localhost") && (record = WebUtils.findSrvRecord(this, remoteAddress)) != null) {
            int remotePort = Integer.parseInt(record[2]);
            remoteAddress = record[3];
            config.getRemote().setAddress(remoteAddress);
            config.getRemote().setPort(remotePort);
            logger.debug("Found SRV record \"" + remoteAddress + ":" + remotePort + "\"");
        }
        TcpSession.USE_EVENT_LOOP_FOR_PACKETS = false;
        String branch = "unknown";
        int buildNumber = -1;
        if (this.productionEnvironment()) {
            try (InputStream stream = this.bootstrap.getResource("git.properties");){
                Properties gitProperties = new Properties();
                gitProperties.load(stream);
                branch = gitProperties.getProperty("git.branch");
                String build = gitProperties.getProperty("git.build.number");
                if (build != null) {
                    buildNumber = Integer.parseInt(build);
                }
            }
            catch (Throwable e) {
                logger.error("Failed to read git.properties", e);
            }
        } else {
            logger.debug("Not getting git properties for the news handler as we are in a development environment.");
        }
        this.pendingMicrosoftAuthentication = new PendingMicrosoftAuthentication(config.getPendingAuthenticationTimeout());
        this.newsHandler = new NewsHandler(branch, buildNumber);
        CooldownUtils.setDefaultShowCooldown(config.getShowCooldown());
        DimensionUtils.changeBedrockNetherId(config.isAboveBedrockNetherBuilding());
        RakNetConstants.MAXIMUM_MTU_SIZE = (short)config.getMtu();
        logger.debug("Setting MTU to " + config.getMtu());
        Integer bedrockThreadCount = Integer.getInteger("Geyser.BedrockNetworkThreads");
        if (bedrockThreadCount == null) {
            bedrockThreadCount = Math.max(1, SystemPropertyUtil.getInt("io.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 2));
        }
        boolean enableProxyProtocol = config.getBedrock().isEnableProxyProtocol();
        this.bedrockServer = new BedrockServer(new InetSocketAddress(config.getBedrock().getAddress(), config.getBedrock().getPort()), bedrockThreadCount, EventLoops.commonGroup(), enableProxyProtocol);
        if (config.isDebugMode()) {
            logger.debug("EventLoop type: " + EventLoops.getChannelType());
            if (EventLoops.getChannelType() == EventLoops.ChannelType.NIO) {
                if (System.getProperties().contains("disableNativeEventLoop")) {
                    logger.debug("EventLoop type is NIO because native event loops are disabled.");
                } else {
                    logger.debug("Reason for no Epoll: " + Epoll.unavailabilityCause().toString());
                    logger.debug("Reason for no KQueue: " + KQueue.unavailabilityCause().toString());
                }
            }
        }
        this.bedrockServer.setHandler(new ConnectorServerEventHandler(this));
        if (shouldStartListener) {
            ((CompletableFuture)this.bedrockServer.bind().whenComplete((avoid, throwable) -> {
                if (throwable == null) {
                    logger.info(GeyserLocale.getLocaleStringLog("geyser.core.start", config.getBedrock().getAddress(), String.valueOf(config.getBedrock().getPort())));
                } else {
                    String address = config.getBedrock().getAddress();
                    int port = config.getBedrock().getPort();
                    logger.severe(GeyserLocale.getLocaleStringLog("geyser.core.fail", address, String.valueOf(port)));
                    if (!"0.0.0.0".equals(address)) {
                        logger.info("\u00a7aSuggestion: try setting `address` under `bedrock` in the Geyser config back to 0.0.0.0");
                        logger.info("\u00a7aThen, restart this server.");
                    }
                }
            })).join();
        }
        if (config.getRemote().getAuthType() == AuthType.FLOODGATE) {
            try {
                Key key = new AesKeyProducer().produceFrom(config.getFloodgateKeyPath());
                this.cipher = new AesCipher(new Base64Topping());
                this.cipher.init(key);
                logger.debug(GeyserLocale.getLocaleStringLog("geyser.auth.floodgate.loaded_key", new Object[0]));
                this.skinUploader = new FloodgateSkinUploader(this).start();
            }
            catch (Exception exception) {
                logger.severe(GeyserLocale.getLocaleStringLog("geyser.auth.floodgate.bad_key", new Object[0]), exception);
            }
        }
        if (config.getMetrics().isEnabled()) {
            this.metrics = new Metrics(this, "GeyserMC", config.getMetrics().getUniqueId(), false, Logger.getLogger(""));
            this.metrics.addCustomChart(new Metrics.SingleLineChart("players", this.sessionManager::size));
            this.metrics.addCustomChart(new Metrics.SimplePie("authMode", () -> config.getRemote().getAuthType().toString().toLowerCase(Locale.ROOT)));
            this.metrics.addCustomChart(new Metrics.SimplePie("platform", this.platformType::getPlatformName));
            this.metrics.addCustomChart(new Metrics.SimplePie("defaultLocale", GeyserLocale::getDefaultLocale));
            this.metrics.addCustomChart(new Metrics.SimplePie("version", () -> VERSION));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("playerPlatform", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (GeyserSession session : this.sessionManager.getAllSessions()) {
                    if (session == null || session.getClientData() == null) continue;
                    String os = session.getClientData().getDeviceOs().toString();
                    if (!valueMap.containsKey(os)) {
                        valueMap.put(os, 1);
                        continue;
                    }
                    valueMap.put(os, (Integer)valueMap.get(os) + 1);
                }
                return valueMap;
            }));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("playerVersion", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (GeyserSession session : this.sessionManager.getAllSessions()) {
                    if (session == null || session.getClientData() == null) continue;
                    String version = session.getClientData().getGameVersion();
                    if (!valueMap.containsKey(version)) {
                        valueMap.put(version, 1);
                        continue;
                    }
                    valueMap.put(version, (Integer)valueMap.get(version) + 1);
                }
                return valueMap;
            }));
            String minecraftVersion = this.bootstrap.getMinecraftServerVersion();
            if (minecraftVersion != null) {
                HashMap versionMap = new HashMap();
                HashMap<String, Integer> platformMap = new HashMap<String, Integer>();
                platformMap.put(this.platformType.getPlatformName(), 1);
                versionMap.put(minecraftVersion, platformMap);
                this.metrics.addCustomChart(new Metrics.DrilldownPie("minecraftServerVersion", () -> versionMap));
            }
            this.metrics.addCustomChart(new Metrics.DrilldownPie("javaVersion", () -> {
                String release;
                HashMap map = new HashMap();
                String javaVersion = System.getProperty("java.version");
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(javaVersion, 1);
                String majorVersion = javaVersion.split("\\.")[0];
                int indexOf = javaVersion.lastIndexOf(46);
                if (majorVersion.equals("1")) {
                    release = "Java " + javaVersion.substring(0, indexOf);
                } else {
                    Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                    if (versionMatcher.find()) {
                        majorVersion = versionMatcher.group(0);
                    }
                    release = "Java " + majorVersion;
                }
                map.put((CallSite)((Object)release), entry);
                return map;
            }));
        } else {
            this.metrics = null;
        }
        if (config.getRemote().getAuthType() == AuthType.ONLINE) {
            if (config.getUserAuths() != null && !config.getUserAuths().isEmpty()) {
                this.getLogger().warning("The 'userAuths' config section is now deprecated, and will be removed in the near future! Please migrate to the new 'saved-user-logins' config option: https://wiki.geysermc.org/geyser/understanding-the-config/");
            }
            this.savedRefreshTokens = new ConcurrentHashMap<String, String>();
            File tokensFile = this.bootstrap.getSavedUserLoginsFolder().resolve("saved-refresh-tokens.json").toFile();
            if (tokensFile.exists()) {
                TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};
                Map<String, String> refreshTokenFile = null;
                try {
                    refreshTokenFile = JSON_MAPPER.readValue(tokensFile, type);
                }
                catch (IOException e) {
                    logger.error("Cannot load saved user tokens!", e);
                }
                if (refreshTokenFile != null) {
                    List<String> validUsers = config.getSavedUserLogins();
                    boolean doWrite = false;
                    for (Map.Entry<String, String> entry : refreshTokenFile.entrySet()) {
                        String user = entry.getKey();
                        if (!validUsers.contains(user)) {
                            doWrite = true;
                            continue;
                        }
                        this.savedRefreshTokens.put(user, entry.getValue());
                    }
                    if (doWrite) {
                        this.scheduleRefreshTokensWrite();
                    }
                }
            }
        } else {
            this.savedRefreshTokens = null;
        }
        this.newsHandler.handleNews(null, NewsItemAction.ON_SERVER_STARTED);
    }

    @Override
    public @Nullable GeyserSession connectionByName(@NonNull String name) {
        for (GeyserSession session : this.sessionManager.getAllSessions()) {
            if (!session.name().equals(name) && !session.getProtocol().getProfile().getName().equals(name)) continue;
            return session;
        }
        return null;
    }

    public @NonNull List<GeyserSession> onlineConnections() {
        return this.sessionManager.getAllSessions();
    }

    @Override
    public @Nullable GeyserSession connectionByUuid(@NonNull UUID uuid) {
        return this.sessionManager.getSessions().get(uuid);
    }

    @Override
    public @Nullable GeyserSession connectionByXuid(@NonNull String xuid) {
        for (GeyserSession session : this.sessionManager.getAllSessions()) {
            if (!session.xuid().equals(xuid)) continue;
            return session;
        }
        return null;
    }

    @Override
    public void shutdown() {
        this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown", new Object[0]));
        this.shuttingDown = true;
        if (this.sessionManager.size() >= 1) {
            this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.log", this.sessionManager.size()));
            this.sessionManager.disconnectAll("geyser.core.shutdown.kick.message");
            this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.done", new Object[0]));
        }
        this.scheduledThread.shutdown();
        this.bedrockServer.close();
        if (this.skinUploader != null) {
            this.skinUploader.close();
        }
        this.newsHandler.shutdown();
        this.getCommandManager().getCommands().clear();
        ResourcePack.PACKS.clear();
        this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.done", new Object[0]));
    }

    @Override
    public void reload() {
        this.shutdown();
        this.bootstrap.onEnable();
    }

    @Override
    public boolean productionEnvironment() {
        return !"DEV".equals(VERSION);
    }

    public static GeyserImpl start(PlatformType platformType, GeyserBootstrap bootstrap) {
        if (instance == null) {
            return new GeyserImpl(platformType, bootstrap);
        }
        if (instance.isShuttingDown()) {
            GeyserImpl.instance.shuttingDown = false;
            instance.start();
        }
        return instance;
    }

    public GeyserLogger getLogger() {
        return this.bootstrap.getGeyserLogger();
    }

    public GeyserConfiguration getConfig() {
        return this.bootstrap.getGeyserConfig();
    }

    public CommandManager getCommandManager() {
        return this.bootstrap.getGeyserCommandManager();
    }

    public WorldManager getWorldManager() {
        return this.bootstrap.getWorldManager();
    }

    public @Nullable String refreshTokenFor(@NonNull String bedrockName) {
        return this.savedRefreshTokens.get(bedrockName);
    }

    public void saveRefreshToken(@NonNull String bedrockName, @NonNull String refreshToken) {
        if (!this.getConfig().getSavedUserLogins().contains(bedrockName)) {
            return;
        }
        if (!Objects.equals(refreshToken, this.savedRefreshTokens.put(bedrockName, refreshToken))) {
            this.scheduleRefreshTokensWrite();
        }
    }

    private void scheduleRefreshTokensWrite() {
        this.scheduledThread.execute(() -> {
            File savedTokens = this.getBootstrap().getSavedUserLoginsFolder().resolve("saved-refresh-tokens.json").toFile();
            TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};
            try (FileWriter writer = new FileWriter(savedTokens);){
                JSON_MAPPER.writerFor(type).withDefaultPrettyPrinter().writeValue(writer, this.savedRefreshTokens);
            }
            catch (IOException e) {
                this.getLogger().error("Unable to write saved refresh tokens!", e);
            }
        });
    }

    public static GeyserImpl getInstance() {
        return instance;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public FloodgateCipher getCipher() {
        return this.cipher;
    }

    public FloodgateSkinUploader getSkinUploader() {
        return this.skinUploader;
    }

    public NewsHandler getNewsHandler() {
        return this.newsHandler;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public ScheduledExecutorService getScheduledThread() {
        return this.scheduledThread;
    }

    public BedrockServer getBedrockServer() {
        return this.bedrockServer;
    }

    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public GeyserBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public PendingMicrosoftAuthentication getPendingMicrosoftAuthentication() {
        return this.pendingMicrosoftAuthentication;
    }

    public static void setShouldStartListener(boolean shouldStartListener) {
        GeyserImpl.shouldStartListener = shouldStartListener;
    }
}

